
/*
 *	Widgets
 */

#include <stdio.h>
#include <X11/Intrinsic.h>	/* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>	/* Include the Label widget's header file. */
#include <X11/Xaw/Cardinals.h>	/* Definition of ZERO. */
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include "map.h"
#include "par.h"

extern	void	quit(), simulate(), init_neurons(), points(), array_select(), distrib_select(),
		lr_select(), inject_fault(), ttd_select(), new_ttd_window(), online_help(),
		spin_objects(), toggle_frame(), invert_windows(), if_select();
extern	double	alpha, radius, alpha_decay, zspace, sigma;
extern	int	xstate, ystate, zstate, neurons, array, distribution, distrib_seed, neuron_seed,
		iterations, map_update, learning_rule, fault_seed, dimension, decay_time;
extern	XStuff	X;

void	create_widgets(), get_parameters(), get_once_parameters();
Widget	message, alpha_w, radius_w, array_w, distrib_w, lr_w, array_mw, distrib_mw, lr_mw, ttd_w, ttd_mw,
	framew, if_mw, if_w;
char	param[PARAMS][PARAM_SIZE];
char*	array_menu[] = {
	"rectangular", "linear", "hexagonal", "rect-4", "ring"
};
char*	distrib_menu[] = {
	"rectangle", "circle", "triangle", "guassian", "clustered", "city"
};
char*	lr_menu[] = {
	"radius/alpha", "proportional", "infold", "sigma/alpha"
};
char*	ttd_menu[] = {
	"2-dimensional", "3-dimensional"
};
char*	if_menu[] = {
	"Gaussian", "Uniform", "Column"
};

void
create_widgets(toplevel)
Widget		toplevel;
{
	int		i;
	Widget		outer, panel, tmp1, tmp2, init, sim, quitw, xstatew, ystatew, zstate_w,
			below, after, top, poi, entry, neuron_seed_w, distrib_seed_w, helpw,
			iterations_w, map_update_w, fault, new_win, alpha_decay_w, zspace_w, sigma_w,
			spinw, invertw;
	static	Arg	messageargs[] = {
		XtNheight,		(XtArgVal)18,
		XtNwidth,		(XtArgVal)483,
		XtNfromVert,		(XtArgVal)NULL
	};
	static	Arg	textargs[] = {
		XtNlength,		(XtArgVal)8,
		XtNwidth,		(XtArgVal)60,
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL,
		XtNstring,		(XtArgVal)NULL,
		XtNhorizDistance,	(XtArgVal)10,
		XtNinsertPosition,	(XtArgVal)NULL,
		XtNeditType,		(XtArgVal)XawtextEdit,
		XtNuseStringInPlace, 	(XtArgVal)True
	};
	static	Arg	formargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL,
		XtNborderWidth,		(XtArgVal)0,
		XtNvertDistance,	(XtArgVal)0
	};
	static	Arg	labelargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL,
		XtNborderWidth,		(XtArgVal)0
	};
	static	Arg	buttonargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL
	};
	static	Arg	menuargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL
	};

	outer = XtCreateManagedWidget("outer", formWidgetClass, toplevel, NULL, ZERO);
	panel = XtCreateManagedWidget("panel", formWidgetClass, outer, NULL, ZERO);
/*
 *	Values
 */
	tmp1 = XtCreateManagedWidget("xstate", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("XState", labelWidgetClass, tmp1, labelargs, XtNumber(labelargs));
	sprintf(param[XSTATE], "%d", xstate);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[XSTATE];
	textargs[6].value = (XtArgVal)strlen(param[XSTATE]);
	xstatew = XtCreateManagedWidget("xsw", asciiTextWidgetClass, tmp1, textargs, XtNumber(textargs));
	top = tmp1;

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("ystate", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("YState", labelWidgetClass, tmp1, labelargs, XtNumber(labelargs));
	sprintf(param[YSTATE], "%d", ystate);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[YSTATE];
	textargs[6].value = (XtArgVal)strlen(param[YSTATE]);
	ystatew = XtCreateManagedWidget("ysw", asciiTextWidgetClass, tmp1, textargs, XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("zstate", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("ZState", labelWidgetClass, tmp1, labelargs, XtNumber(labelargs));
	sprintf(param[ZSTATE], "%d", zstate);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[ZSTATE];
	textargs[6].value = (XtArgVal)strlen(param[ZSTATE]);
	zstate_w = XtCreateManagedWidget("zsw", asciiTextWidgetClass, tmp1, textargs, XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("alph", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("alpha ", labelWidgetClass, tmp1, labelargs, XtNumber(labelargs));
	sprintf(param[ALPHA], "%1.1lf", alpha);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[ALPHA];
	textargs[6].value = (XtArgVal)strlen(param[ALPHA]);
	alpha_w = XtCreateManagedWidget("alp", asciiTextWidgetClass, tmp1, textargs, XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("radius", labelWidgetClass, tmp1, labelargs, XtNumber(labelargs));
	sprintf(param[RADIUS], "%1.1lf", radius);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[RADIUS];
	textargs[6].value = (XtArgVal)strlen(param[RADIUS]);
	radius_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs, XtNumber(textargs));
	below = tmp1;

	formargs[0].value = (XtArgVal)NULL;
	formargs[1].value = (XtArgVal)top;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("Neuron Seed ", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[NEURON_SEED], "%d", neuron_seed);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[NEURON_SEED];
	textargs[6].value = (XtArgVal)strlen(param[NEURON_SEED]);
	neuron_seed_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));
	top = tmp1;

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("Distrib Seed", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[DISTRIB_SEED], "%d", distrib_seed);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[DISTRIB_SEED];
	textargs[6].value = (XtArgVal)strlen(param[DISTRIB_SEED]);
	distrib_seed_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("fau", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("Fault Seed  ", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[FAULT_SEED], "%d", fault_seed);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[FAULT_SEED];
	textargs[6].value = (XtArgVal)strlen(param[FAULT_SEED]);
	distrib_seed_w = XtCreateManagedWidget("fault", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("Iterations  ", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[ITERATIONS], "%d", iterations);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[ITERATIONS];
	textargs[6].value = (XtArgVal)strlen(param[ITERATIONS]);
	iterations_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("Update Map  ", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[MAP_UPDATE], "%d", map_update);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[MAP_UPDATE];
	textargs[6].value = (XtArgVal)strlen(param[MAP_UPDATE]);
	map_update_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));

	formargs[0].value = (XtArgVal)NULL;
	formargs[1].value = (XtArgVal)top;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("ZSpace     ", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[ZSPACE], "%1.2lf", zspace);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[ZSPACE];
	textargs[6].value = (XtArgVal)strlen(param[ZSPACE]);
	zspace_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));
	top = tmp1;

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("Sigma Decay", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[ALPHA_DECAY], "%1.1lf", alpha_decay);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[ALPHA_DECAY];
	textargs[6].value = (XtArgVal)strlen(param[ALPHA_DECAY]);
	alpha_decay_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("sigma      ", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[SIGMA], "%1.1lf", sigma);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[SIGMA];
	textargs[6].value = (XtArgVal)strlen(param[SIGMA]);
	sigma_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));

	formargs[0].value = (XtArgVal)tmp1;
	tmp1 = XtCreateManagedWidget("rad", formWidgetClass, panel, formargs, XtNumber(formargs));
	tmp2 = XtCreateManagedWidget("Decay Time ", labelWidgetClass, tmp1, labelargs,
					XtNumber(labelargs));
	sprintf(param[DECAY_TIME], "%d", decay_time);
	textargs[3].value = (XtArgVal)tmp2;
	textargs[4].value = (XtArgVal)param[DECAY_TIME];
	textargs[6].value = (XtArgVal)strlen(param[DECAY_TIME]);
	sigma_w = XtCreateManagedWidget("rd", asciiTextWidgetClass, tmp1, textargs,
					XtNumber(textargs));
/*
 *	Menus
 */
	formargs[0].value = (XtArgVal)below;
	formargs[1].value = (XtArgVal)NULL;
	tmp1 = XtCreateManagedWidget("aform", formWidgetClass, panel, formargs, XtNumber(formargs));
	array_w = XtCreateManagedWidget(array_menu[array], menuButtonWidgetClass, tmp1, NULL, ZERO);
	array_mw = XtCreatePopupShell("menu", simpleMenuWidgetClass, array_w, NULL, ZERO);
	for (i=0; i<XtNumber(array_menu); i++) {
		char *item = array_menu[i];
		entry = XtCreateManagedWidget(item, smeBSBObjectClass, array_mw, NULL, ZERO);
		XtAddCallback(entry, XtNcallback, array_select, (XtPointer)i);
	}
	below = tmp1;	

	menuargs[1].value = (XtArgVal)array_w;
	distrib_w = XtCreateManagedWidget(distrib_menu[distribution], menuButtonWidgetClass, tmp1,
					menuargs, XtNumber(menuargs));
	distrib_mw = XtCreatePopupShell("menu", simpleMenuWidgetClass, distrib_w, NULL, ZERO);
	for (i=0; i<XtNumber(distrib_menu); i++) {
		char *item = distrib_menu[i];
		entry = XtCreateManagedWidget(item, smeBSBObjectClass, distrib_mw, NULL, ZERO);
		XtAddCallback(entry, XtNcallback, distrib_select, (XtPointer)i);
	}

	menuargs[1].value = (XtArgVal)distrib_w;
	lr_w = XtCreateManagedWidget(lr_menu[learning_rule], menuButtonWidgetClass, tmp1,
					menuargs, XtNumber(menuargs));
	lr_mw = XtCreatePopupShell("menu", simpleMenuWidgetClass, lr_w, NULL, ZERO);
	for (i=0; i<XtNumber(lr_menu); i++) {
		char *item = lr_menu[i];
		entry = XtCreateManagedWidget(item, smeBSBObjectClass, lr_mw, NULL, ZERO);
		XtAddCallback(entry, XtNcallback, lr_select, (XtPointer)i);
	}

	menuargs[1].value = (XtArgVal)lr_w;
	ttd_w = XtCreateManagedWidget(ttd_menu[dimension], menuButtonWidgetClass, tmp1,
					menuargs, XtNumber(menuargs));
	ttd_mw = XtCreatePopupShell("menu", simpleMenuWidgetClass, ttd_w, NULL, ZERO);
	for (i=0; i<XtNumber(ttd_menu); i++) {
		char *item = ttd_menu[i];
		entry = XtCreateManagedWidget(item, smeBSBObjectClass, ttd_mw, NULL, ZERO);
		XtAddCallback(entry, XtNcallback, ttd_select, (XtPointer)i);
	}

	menuargs[1].value = (XtArgVal)ttd_w;
	if_w = XtCreateManagedWidget(if_menu[dimension], menuButtonWidgetClass, tmp1,
					menuargs, XtNumber(menuargs));
	if_mw = XtCreatePopupShell("menu", simpleMenuWidgetClass, if_w, NULL, ZERO);
	for (i=0; i<XtNumber(if_menu); i++) {
		char *item = if_menu[i];
		entry = XtCreateManagedWidget(item, smeBSBObjectClass, if_mw, NULL, ZERO);
		XtAddCallback(entry, XtNcallback, if_select, (XtPointer)i);
	}
/*
 *	Buttons
 */
	formargs[0].value = (XtArgVal)below;
	formargs[1].value = (XtArgVal)NULL;
	tmp1 = XtCreateManagedWidget("buttons", formWidgetClass, panel, formargs, XtNumber(formargs));
	init = XtCreateManagedWidget("Init Neurons", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(init, XtNcallback, init_neurons, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)init;
	sim = XtCreateManagedWidget("Simulate", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(sim, XtNcallback, simulate, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)sim;
	fault = XtCreateManagedWidget("Inject Fault", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(fault, XtNcallback, inject_fault, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)fault;
	new_win = XtCreateManagedWidget("New Window", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(new_win, XtNcallback, new_ttd_window, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)new_win;
	poi = XtCreateManagedWidget("Points", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(poi, XtNcallback, points, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)poi;
	spinw = XtCreateManagedWidget("Spin", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(spinw, XtNcallback, spin_objects, (XtPointer)toplevel);

	buttonargs[0].value = (XtArgVal)init;
	buttonargs[1].value = (XtArgVal)NULL;
	framew = XtCreateManagedWidget("Frame", toggleWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(framew, XtNcallback, toggle_frame, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)framew;
	invertw = XtCreateManagedWidget("Invert", toggleWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(invertw, XtNcallback, invert_windows, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)invertw;
	helpw = XtCreateManagedWidget("Help", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(helpw, XtNcallback, online_help, (XtPointer)toplevel);

	buttonargs[1].value = (XtArgVal)helpw;
	quitw = XtCreateManagedWidget("quit", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(quitw, XtNcallback, quit, (XtPointer)toplevel);
/*
 *	Message
 */
	messageargs[2].value = (XtArgVal)panel;
	message = XtCreateManagedWidget(" ", labelWidgetClass, outer, messageargs, XtNumber(messageargs));
}

void
get_parameters()
{
	sscanf(param[ALPHA_DECAY], "%lf", &alpha_decay);
	sscanf(param[RADIUS], "%lf", &radius);
	sscanf(param[SIGMA], "%lf", &sigma);
	sscanf(param[ITERATIONS], "%d", &iterations);
	sscanf(param[MAP_UPDATE], "%d", &map_update);
	sscanf(param[ZSPACE], "%lf", &zspace);
	sscanf(param[ALPHA], "%lf", &alpha);
	sscanf(param[DECAY_TIME], "%d", &decay_time);
}

void
get_once_parameters()
{
	sscanf(param[XSTATE], "%d", &xstate);
	sscanf(param[YSTATE], "%d", &ystate);
	sscanf(param[ZSTATE], "%d", &zstate);
	sscanf(param[NEURON_SEED], "%d", &neuron_seed);
	sscanf(param[DISTRIB_SEED], "%d", &distrib_seed);
	sscanf(param[FAULT_SEED], "%d", &fault_seed);
	sscanf(param[ZSPACE], "%lf", &zspace);
	if (xstate > MAXX)
		xstate = MAXX;
	if (ystate > MAXY)
		ystate = MAXY;
	if (zstate > MAXZ)
		zstate = MAXZ;
}
