
/*
 *	Three dimensional handlers
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>	/* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include "map.h"

extern	Widget	toplevel;
extern	XStuff	X;
extern	double	neuron[MAXN][DIM];
extern	int	neurons, xstate, ystate, zstate, array, distribution, distrib_seed;
extern	int	stx[MAXN], sty[MAXN], stz[MAXN], fault_loc[MAXN];
extern	int	get_seed();
extern	void	display_message(), get_window_size(), draw_frame(), set_seed();

int	window	= 0,
	ow_x = -1,
	ow_y = -1;
int	open_new_window();
void	calc_coefficients(), calc_perspective(), update_ttd_window(), home_values(),
	handle_all_ttd_buttons(), update_ttd_message(), draw_plane(), draw_hex();
Pixmap	pixmap;
Widget	ttd_canvas[MAX_WINDOWS], ttd_toplevel[MAX_WINDOWS], ttd_message[MAX_WINDOWS];

double	v11[MAX_WINDOWS], v12[MAX_WINDOWS], v13[MAX_WINDOWS], v21[MAX_WINDOWS], v22[MAX_WINDOWS],
	v23[MAX_WINDOWS], v32[MAX_WINDOWS], v33[MAX_WINDOWS], view_distance[MAX_WINDOWS],
	screen_distance[MAX_WINDOWS];
int	x_angle[MAX_WINDOWS], z_angle[MAX_WINDOWS], dots[MAX_WINDOWS];
int	depth;

void
calc_coefficients(w)
int	w;
{
	double	th, ph, costh, sinth, cosph, sinph, factor;

	factor = atan(1.0) / 45.0;
	th = x_angle[w] * factor;
	ph = z_angle[w] * factor;
	costh = cos(th);
	sinth = sin(th);
	cosph = cos(ph);
	sinph = sin(ph);
	v11[w] = -sinth;	v12[w] = -cosph * costh;	v13[w] = -sinph * costh;
	v21[w] = costh;		v22[w] = -cosph * sinth;	v23[w] = -sinph * sinth;
				v32[w] = sinph;			v33[w] = -cosph;
}

void
calc_perspective(w, x, y, z, pX, pY)
int	w;
double	x, y, z, *pX, *pY;
{
	double	xe, ye, ze;

	x -= 0.5;
	y -= 0.5;
	z -= 0.5;
	xe = v11[w] * x + v21[w] * y;
	ye = v12[w] * x + v22[w] * y + v32[w] * z;
	ze = v13[w] * x + v23[w] * y + v33[w] * z + view_distance[w];
	*pX = screen_distance[w] * xe / ze + 0.5;
	*pY = screen_distance[w] * ye / ze + 0.5;
}

void
home_values(w)
int	w;
{
	view_distance[w] = 2.5;
	screen_distance[w] = 2.0;
	x_angle[w] = 0;
	z_angle[w] = 0;
}

int
open_new_window()
{
	char	buf[20];
	int	wl;
	Widget	tmp1, tmp2, outer;
	static	Arg	canvasargs[] = {
		XtNheight,	(XtArgVal)369,
		XtNwidth,	(XtArgVal)369
	};
	static	Arg	formargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL,
		XtNborderWidth,		(XtArgVal)0
	};
	static	Arg	messageargs[] = {
		XtNheight,		(XtArgVal)18,
		XtNwidth,		(XtArgVal)400,
		XtNfromVert,		(XtArgVal)NULL
	};
	static	Arg	buttonargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL
	};

	if (window >= MAX_WINDOWS)
		return FALSE;

	if (window)
		sprintf(buf, "Display-%d", window+1);
	else {
		for (wl=0; wl<MAX_WINDOWS; wl++)
			dots[wl] = FALSE;
		sprintf(buf, "Main Display");
	}
	ttd_toplevel[window] = XtCreatePopupShell(buf, topLevelShellWidgetClass, toplevel, NULL, 0);
	outer = XtCreateManagedWidget("outer", formWidgetClass, ttd_toplevel[window], NULL, 0);
	ttd_canvas[window] = XtCreateManagedWidget("canvas", widgetClass, outer, canvasargs,
						XtNumber(canvasargs));

	messageargs[1].value = canvasargs[1].value;
	messageargs[2].value = (XtArgVal)ttd_canvas[window];
	ttd_message[window] = XtCreateManagedWidget(" ", labelWidgetClass, outer,
						messageargs, XtNumber(messageargs));

	wl = window * 100;
	formargs[0].value = (XtArgVal)ttd_message[window];
	formargs[1].value = (XtArgVal)NULL;
	tmp1 = XtCreateManagedWidget("buttons", formWidgetClass, outer, formargs,
						XtNumber(formargs));
	buttonargs[1].value = (XtArgVal)NULL;
	tmp2 = XtCreateManagedWidget("Dots", toggleWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, DOTS + wl);

	buttonargs[1].value = (XtArgVal)tmp2;
	tmp2 = XtCreateManagedWidget("Closer", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, MOVE_CLOSER + wl);

	buttonargs[1].value = (XtArgVal)tmp2;
	tmp2 = XtCreateManagedWidget("Further", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, MOVE_FURTHER + wl);

	buttonargs[1].value = (XtArgVal)tmp2;
	tmp2 = XtCreateManagedWidget("Left", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, MOVE_LEFT + wl);

	buttonargs[1].value = (XtArgVal)tmp2;
	tmp2 = XtCreateManagedWidget("Right", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, MOVE_RIGHT + wl);

	buttonargs[1].value = (XtArgVal)tmp2;
	tmp2 = XtCreateManagedWidget("Up", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, MOVE_UP + wl);

	buttonargs[1].value = (XtArgVal)tmp2;
	tmp2 = XtCreateManagedWidget("Down", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
	XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, MOVE_DOWN + wl);

	if (window) {
		buttonargs[1].value = (XtArgVal)tmp2;
		tmp2 = XtCreateManagedWidget("Close", commandWidgetClass, tmp1, buttonargs,
					XtNumber(buttonargs));
		XtAddCallback(tmp2, XtNcallback, handle_all_ttd_buttons, CLOSE_WINDOW + wl);
	}

	XtRealizeWidget(ttd_toplevel[window]);
	XtPopup(ttd_toplevel[window], XtGrabNone);
	X.wins[window] = XtWindow(ttd_canvas[window]);
	home_values(window);
	calc_coefficients(window);
	update_ttd_message(window);
	window++;
	return TRUE;
}

void
draw_plane(z, w, coord, points, w_x, w_y)
int	z, w, w_x, w_y;
XPoint	*coord, *points;
{
	int	ct, n, num_points, x, y;
	double	pX, pY;

	num_points = 0;
	for (x=0; x<xstate; x++) {
		ct = 0;
		for (y=0; y<ystate; y++) {
			n = x + ystate * (y + xstate * z);
			if (fault_loc[n]) {
				if (ct > 1)
					XDrawLines(X.dpy, pixmap, X.gc, coord, ct, CoordModeOrigin);
				if (ct == 1) {
					points[num_points].x = coord[0].x;
					points[num_points].y = coord[0].y;
					num_points++;
				}
				ct = 0;
			} else {
				calc_perspective(w, neuron[n][0], neuron[n][1], neuron[n][2], &pX, &pY);
				coord[ct].x = pX * w_x;
				coord[ct].y = pY * w_y;
				ct++;
			}
		}
		if (ct > 1)
			XDrawLines(X.dpy, pixmap, X.gc, coord, ct, CoordModeOrigin);
	}
	if (num_points)
		XDrawPoints(X.dpy, pixmap, X.gc, points, num_points, CoordModeOrigin);
	for (y=0; y<ystate; y++) {
		ct = 0;
		n = ystate * (y + xstate * z);
		for (x=0; x<xstate; x++) {
			if (fault_loc[n]) {
				if (ct > 1)
					XDrawLines(X.dpy, pixmap, X.gc, coord, ct, CoordModeOrigin);
				ct = 0;
			} else {
				calc_perspective(w, neuron[n][0], neuron[n][1], neuron[n][2], &pX, &pY);
				coord[ct].x = pX * w_x;
				coord[ct].y = pY * w_y;
				ct++;
			}
			n++;
		}
		if (ct > 1)
			XDrawLines(X.dpy, pixmap, X.gc, coord, ct, CoordModeOrigin);
	}
}

void
draw_hex(z, w, coord, w_x, w_y)
int	z, w, w_x, w_y;
XPoint	*coord;
{
	int	x, y, n;
	double	pX, pY;

	for (x=0; x<xstate-1; x++) {
		for (y=0; y<ystate; y++) {
			if (y % 2)
				n = y * ystate + x;
			else
				n = y * ystate + x + 1;
			calc_perspective(w, neuron[n][0], neuron[n][1], neuron[n][2], &pX, &pY);
			coord[y].x = pX * w_x;
			coord[y].y = pY * w_y;
		}
		XDrawLines(X.dpy, pixmap, X.gc, coord, ystate, CoordModeOrigin);
	}
	for (x=0; x<xstate; x++) {
		n = x;
		for (y=0; y<ystate; y++) {
			calc_perspective(w, neuron[n][0], neuron[n][1], neuron[n][2], &pX, &pY);
			coord[y].x = pX * w_x;
			coord[y].y = pY * w_y;
			n += ystate;
		}
		XDrawLines(X.dpy, pixmap, X.gc, coord, ystate, CoordModeOrigin);
	}
	for (y=0; y<ystate; y++) {
		n = y * ystate;
		for (x=0; x<xstate; x++) {
			calc_perspective(w, neuron[n][0], neuron[n][1], neuron[n][2], &pX, &pY);
			coord[x].x = pX * w_x;
			coord[x].y = pY * w_y;
			n++;
		}
		XDrawLines(X.dpy, pixmap, X.gc, coord, xstate, CoordModeOrigin);
	}
}

void
update_ttd_window(w)
int	w;
{
	int	x, y, z, w_x, w_y, vertices, n, ct, num_points;
	double	pX, pY, xxx, yyy, zzz;
	XPoint	*coord, *points;

	get_window_size(ttd_canvas[w], &w_x, &w_y);
	if ((w_x > ow_x) || (w_y > ow_y)) {
		if (ow_x > 0)
			XFreePixmap(X.dpy, pixmap);
		else
			depth = DefaultDepth(X.dpy, 0);
		pixmap = XCreatePixmap(X.dpy, X.wins[0], w_x, w_y, depth);
		ow_x = w_x;
		ow_y = w_y;
	}
	XFillRectangle(X.dpy, pixmap, X.gcd, 0, 0, w_x, w_y);
	if (dots[w]) {
		n = 0;
		coord = (XPoint*)malloc(sizeof(XPoint) * neurons);
		for (x=0; x<neurons; x++)
			if (fault_loc[x] == 0) {
				calc_perspective(w, neuron[x][0], neuron[x][1], neuron[x][2], &pX, &pY);
				coord[n].x = pX * w_x;
				coord[n].y = pY * w_y;
				n++;
			}
		XDrawPoints(X.dpy, pixmap, X.gc, coord, n, CoordModeOrigin);

	} else
	switch (array) {
	case RECTANGULAR:
	case RECT_4:
		if (xstate > ystate)
			vertices = xstate;
		else
			vertices = ystate;
		if (zstate > vertices)
			vertices = zstate;
		coord = (XPoint *)malloc(sizeof(XPoint) * vertices);
		points = (XPoint *)malloc(sizeof(XPoint) * neurons/2);
		for (z=0; z<zstate; z++)
			draw_plane(z, w, coord, points, w_x, w_y);
		free(points);
		break;
	case LINEAR:
		coord = (XPoint*)malloc(sizeof(XPoint) * neurons);
		for (x=0; x<neurons; x++) {
			calc_perspective(w, neuron[x][0], neuron[x][1], neuron[x][2], &pX, &pY);
			coord[x].x = pX * w_x;
			coord[x].y = pY * w_y;
		}
		XDrawLines(X.dpy, pixmap, X.gc, coord, neurons, CoordModeOrigin);
		break;
	case HEXAGONAL:
		if (xstate > ystate)
			vertices = xstate;
		else
			vertices = ystate;
		coord = (XPoint *)malloc(sizeof(XPoint) * vertices);
		draw_hex(0, w, coord, w_x, w_y);
		break;
	case RING:
		coord = (XPoint*)malloc(sizeof(XPoint) * neurons+1);
		for (x=0; x<neurons; x++) {
			calc_perspective(w, neuron[x][0], neuron[x][1], neuron[x][2], &pX, &pY);
			coord[x].x = pX * w_x;
			coord[x].y = pY * w_y;
		}
		coord[neurons].x = coord[0].x;
		coord[neurons].y = coord[0].y;
		XDrawLines(X.dpy, pixmap, X.gc, coord, neurons+1, CoordModeOrigin);
		break;
	}
	if (distribution == CITY) {
		y = get_seed();
		init_seed(distrib_seed);
		for (x=0; x<neurons; x++) {
			get_distribution(&xxx, &yyy, &zzz);
			calc_perspective(w, xxx, yyy, zzz, &pX, &pY);
			coord[x].x = pX * w_x;
			coord[x].y = pY * w_y;
		}
		XDrawPoints(X.dpy, pixmap, X.gc, coord, neurons, CoordModeOrigin);
		set_seed(y);
	}
	XCopyArea(X.dpy, pixmap, X.wins[w], X.gc, 0, 0, w_x, w_y, 0, 0);
	draw_frame(w);
	XFlush(X.dpy);
	free(coord);
}

void
handle_all_ttd_buttons(wid, client_data, call_data)
Widget		wid;
int		client_data;
XtPointer	call_data;
{
	int	w;

	w = client_data / 100;
	client_data %= 100;
	switch (client_data) {
		case CLOSE_WINDOW:
			XtDestroyWidget(ttd_toplevel[w]);
			window--;
			return;
			break;
		case DOTS:
			dots[w] = 1 - dots[w];
			break;
		case MOVE_CLOSER:
			view_distance[w] -= 0.2;
			if (view_distance[w] < 2.1)
				view_distance[w] = 2.1;
			break;
		case MOVE_FURTHER:
			view_distance[w] += 0.2;
			if (view_distance[w] > 12.1)
				view_distance[w] = 12.1;
			break;
		case MOVE_RIGHT:
			x_angle[w] += ANGLE_INC;
			if (x_angle[w] >= 360)
				x_angle[w] -= 360;
			break;
		case MOVE_LEFT:
			x_angle[w] -= ANGLE_INC;
			if (x_angle[w] < 0)
				x_angle[w] += 360;
			break;
		case MOVE_UP:
			z_angle[w] += ANGLE_INC;
			if (z_angle[w] >= 360)
				z_angle[w] -= 360;
			break;
		case MOVE_DOWN:
			z_angle[w] -= ANGLE_INC;
			if (z_angle[w] < 0)
				z_angle[w] += 360;
			break;
	}
	update_ttd_message(w);
	calc_coefficients(w, x_angle[w], z_angle[w]);
	update_ttd_window(w);
}

void
update_ttd_message(w)
int	w;
{
	char	buf[80];
	static	Arg	args[1];

	sprintf(buf, "x angle: %d   z angle: %d   distance: %1.1lf",
		x_angle[w], z_angle[w], (view_distance[w] - 2.1) * 0.5);
	XtSetArg(args[0], XtNlabel, buf);
	XtSetValues(ttd_message[w], args, 1);
}
