
/*
 *	ram.c - Contains for code for uniform and normal random number
 *		generation.  This is a correct RNG.
 */

#include <math.h>

static	int	seed = 1;

double	randm(), normal();
int	get_seed();
void	init_seed(), set_seed();

/*
 *	Given an integer, this routine inits the RNG seed.
 */
void
init_seed(s)
int	s;
{
	if ((seed = s % 44488 * 48271 - s / 44488 * 3399) < 0)
		seed += 2147483647;
}

/*
 *	Returns current value of the local RNG seed.
 */
int
get_seed()
{
	return seed;
}

/*
 *	Sets to seed to the value passed.
 */
void
set_seed(s)
int	s;
{
	seed = s;
}

/*
 *	Returns a random number between 0 and 1, non-inclusive.
 *	Call init_seed() first.
 */
double
randm()
{
	if ((seed = seed % 44488 * 48271 - seed / 44488 * 3399) < 0)
		seed += 2147483647;
	return seed / 2147483647.0;
}

/*
 *	Returns a standard normal distributed real. Uses a very accurate
 *	approximation of the Normal idf due to Odeh & Evans, J. Applied
 *	Statistics, 1974, vol 23, pp 96-97.
 */
#define	p0	0.322232431088
#define	p1	1.0
#define	p2	0.342242088547
#define	p3	0.204231210245e-1
#define	p4	0.453642210148e-4
#define	q0	0.099348462606
#define	q1	0.588581570495
#define	q2	0.531103462366
#define	q3	0.103537752850
#define	q4	0.385607006340e-2
double
normal()
{
	double	u, t, p, q;

	u = randm();
	if (u < 0.5)
		t = sqrt(-2.0 * log(u));
	else
		t = sqrt(-2.0 * log(1.0 - u));
	p = p0 + t * (p1 + t * (p2 + t * (p3 + t * p4)));
	q = q0 + t * (q1 + t * (q2 + t * (q3 + t * q4)));
	if (u < 0.5)
		return (p / q) - t;
	return t - (p / q);
}
