
#define	MAXX		50	/* Max size of map in x		*/
#define	MAXY		50	/* Max size of map in y		*/
#define	MAXZ		10	/* Max size of map in z		*/
#define	MAXN		MAXX*MAXY*MAXZ	/* Max number of neurons*/
#define	DIM		3	/* Dimension of space		*/
#define	MAX_WINDOWS	3	/* max # of 3D windows allowed	*/
#define	ANGLE_INC	10	/* degrees angle should change	*/

typedef	struct	{
	Display	*dpy;		/* the display			*/
	Screen	*scr;		/* the screen			*/
	Window	wins[MAX_WINDOWS]; /* display windows		*/
	GC	gc, gcd;	/* the GC & dashed line GC	*/
	XGCValues gcv;		/* copy of what's in the GC	*/
	Pixel	foreground;
	Pixel	background;
}	XStuff;

/*
 *	These are the menu assignments which must match the order of
 *	the listing of the menu in wid.c.
 */
#define	RECTANGLE	0
#define	CIRCLE		1
#define	TRIANGLE	2
#define	GAUSSIAN	3
#define	CLUSTERED	4
#define	CITY		5

#define	RECTANGULAR	0
#define	LINEAR		1
#define	HEXAGONAL	2
#define	RECT_4		3
#define	RING		4

#define	RADIUS_ALPHA	0
#define	PROPORTIONAL	1
#define	INFOLD		2
#define	SIGMA_ALPHA	3

#define	DIMENSION2	0
#define	DIMENSION3	1

#define	GAUSIAN		0
#define	UNIFORM		1
#define	HALF		2

/*
 *	These are functions for the 3D buttons
 */
#define	HOME_VALUES	1
#define	MOVE_CLOSER	2
#define	MOVE_FURTHER	3
#define	MOVE_RIGHT	4
#define	MOVE_LEFT	5
#define	MOVE_UP		6
#define	MOVE_DOWN	7
#define	CLOSE_WINDOW	8
#define	DOTS		9
