
/*
 *	The text of the help messages.
 */

static	char	*help_msg[] = {
"\n\
			  R O X A N N E\n\
      Read Only X Window Artificial Neural Network Emulator\n\
\n\
\n\
	ROXANNE is an interactive X Window simulator of 1, 2 and 3\n\
dimensional Kohonen Self-Organizing Maps.  The simulator has a main\n\
panel of parameters, menus and function buttons.  Also, there can be\n\
several display windows.  One will automatically pop up when the\n\
program is run.  Others can be enabled by choosing the New Window\n\
button.  The Self-Organizing Map tries to find a optimum mapping of\n\
of the input stream in the input space.  Lower dimensional networks\n\
can be used to map higher dimensional spaces.\n\
\n\
\n\
	Version:	2.4\n\
	Written by:	Michael K. Arras\n\
	e-mail:		arras@icase.edu\n\
	Copyright:	(c) 1991 Institute for Computer Applications\n\
			in Science and Engineering (ICASE)\
",
"\n\
			Variable Definitions\n\
			====================\n\
\n\
Seeds - The seeds are non-zero integers that determine the initial\n\
	value of the Lehmer random number generator seeds.  The\n\
	neuron seed is for initial values of the weights of the\n\
	neurons.  This must be set before initializing the neurons.\n\
	The distrib seed is for the random points used as input,\n\
	and the fault seed is used for picking which neuron fails.\n\
\n\
Iterations - Specifies the number of input points to run every\n\
	     time the simulate button is pressed.  Also, when\n\
	     Sigma Decay is not equal to 1.0, it states the\n\
	     number of iterations to take for the cooling schedule.\n\
	     Be careful using large values, because once it started\n\
	     there is no way to stop it.\n\
\n\
Update Map - Specifies the number of iterations to wait before the\n\
	     display is updated with the new values of the weights.\n\
	     The display is always updated when the simulation is\n\
	     completed.\n\
\n\
ZSpace - This number specifies the depth of the space in the Z\n\
	 direction.  A value of 0.0 means the space is actually\n\
	 a plane (2D).  A value of 1.0 means that the space is\n\
	 a cube.  The values for both X and Y are fixed at 1.0.\n\
\n\
Sigma Decay - Determines the exponential rate of decay that sigma\n\
	      should decrease at.  Sigma Decay must be exactly\n\
	      1.0 for no decay to occur.  When Sigma Decay is\n\
	      not 1.0, both alpha decreases from alpha to\n\
	      alpha*0.04 and sigma decrease from sigma to\n\
	      sigma * sigma_decay.  A good number is 0.2.\n\
\n\
Decay Time - The number of iterations over which sigma and alpha\n\
	     are to decrease.  After this many iterations sigma\n\
	     and alpha will be so small, the map will be\n\
	     practically frozen.  If Iterations is 500 and Decay\n\
	     Time is 2000, Simulate must be pressed four times to\n\
	     get the full cooling.\
",
"\n\
			State Variables\n\
			===============\n\
\n\
XState - The number of neurons in the X direction.  The maximum value\n\
	 allowed is 50.\n\
\n\
YState - The number of neurons in the Y direction.  The maximum value\n\
	 allowed is 50.\n\
\n\
ZState - The number of neurons in the Z direction.  The maximum value\n\
	 allowed is 10.\n\
\n\
alpha - This is the `learning rate' of the system.  It makes no sense\n\
	to have values that are smaller than 0.0 or greater than 1.0.\n\
	As the system stabilizes, alpha should get smaller.\n\
\n\
radius - The number of neighbors that are effected by the nearest\n\
	 neighbor rule.  A radius of 0 means that only 1 neurons\n\
	 weights are altered.  With a 2D rectangular array of\n\
	 neurons and radius 1, the 8 adjacent neighbors weights get\n\
	 altered.\n\
\n\
sigma - This determines the neighborhood when the sigma/alpha\n\
	learning rule is selected.  This is monotonically decreased\n\
	when Sigma Decay is less than 1.0.\
",
"\n\
			Menu Choices\n\
			============\n\
\n\
rectangular - The options found here specify the geometry of the\n\
	      self-organizing map.  Rect-4 means that only the\n\
	      immediate four neighbors get changed when using the\n\
	      radius/alpha method.\n\
\n\
rectangle - This specifies the input distribution.  Simply choose a\n\
	    distribution and press Points to see what it looks like.\n\
\n\
radius/alpha - These are four weight adaptation techniques.  An\n\
	       explanation is beyond the scope of the help.\n\
\n\
2-dimensional - Specifies whether the input space is 2D or 3D.\n\
\n\
Gaussian - When a fault is injected into the network, this determines\n\
	   where the fault shall occur.  Gaussian means in the center,\n\
	   uniform means randomly, and column means that an entire\n\
	   column of neurons get killed.\
",
"\n\
			Button Functions\n\
			================\n\
\n\
Init Neurons - This button initializes the value of the neurons and\n\
	       sets up for simulation.\n\
\n\
Simulate - This runs the simulation for the set number of\n\
	   iterations.\n\
\n\
Inject Fault - This disables a neuron.  It randomly picks a neuron\n\
	       in the center of the neuron map and makes like it\n\
	       never existed.\n\
\n\
New Window - This opens a new display window.  It behaves as and has\n\
	     all the functionality of the main display.\n\
\n\
Points - This displays 1000 points to illustrate the probability\n\
	 distribution of the inputs.  If done repeatedly, it shows\n\
	 the density of points in the input space.  Doing this causes\n\
	 no change to the state of the simulation.\n\
\n\
Spin - Spins the objects at eight degree intervals, until the object\n\
       is back in its original location.  This is used mostly for\n\
       viewing complicated 3D objects.\n\
\n\
Frame - This toggle button draws a dashed line frame around the\n\
	object so that the input space can be easily seen.  Pushing\n\
	frame twice turns the frame off.  This does not work with\n\
	all distributions.\n\
\n\
Invert - Simply swaps the background and foreground colors of the\n\
	 actual display windows.\n\
\n\
Help - Brings up this help window.\n\
\n\
Quit - Exits the simulator completely.\
",
"\n\
			Window Buttons\n\
			==============\n\
\n\
Dots - This toggles the drawing of the lines connecting each\n\
       neuron.\n\
\n\
Closer - This moves the view point closer to the object so it\n\
	 appears larger.\n\
\n\
Further - Moves the view point further from the object.\n\
\n\
Left - Decrements the x-angle and changes the view point.\n\
\n\
Right - Increments the x-angle and changes the view point.\n\
\n\
Up - Decrements the z-angle and changes the view point.\n\
\n\
Down - Increments the z-angle and changes the view point.\n\
\n\
Close - Closes the additional display opened.  If three\n\
	displays are open, do not close the second display\n\
	if the third one is still open.\
",
"\n\
			Some Examples\n\
			=============\n\
\n\
Radius/Alpha:\n\
\n\
	In order for a decent map to occur, some sort of cooling\n\
schedule must be used.  For the radius/alpha method this must be\n\
done by hand.  To do this, using the default parameter settings\n\
press `Init Neurons' then `Simulate'.  This runs for 500\n\
iterations with alpha=0.8 and radius=3.  Change alpha to 0.5.  DO\n\
NOT press return after changing these variables!  Now press\n\
`Simulate' again.  Change alpha to 0.2 and radius to 2. Press\n\
`Simulate'.  Change alpha to 0.1 and radius to 1. Press `Simulate'\n\
as many times as you like.  To see it adapt to a different input\n\
distribution change `rectangle' to `triangle' and press `Points'.\n\
Now press `Simulate' at least five times.\n\
\n\
Sigma/Alpha:\n\
\n\
	Choose sigma/alpha as the learning rule.  Set alpha to 0.8,\n\
sigma to 3 and Sigma Decay to 0.2.  Press `Init Neurons' then\n\
`Simulate' four times.  Four times because the Decay Time is 2000\n\
and the Iterations run every time `Simulate' is pressed is 500.\n\
\n\
3D Example:\n\
\n\
	Set XState, YState and ZState to 5.  Set ZSpace to 1.0.\n\
Change the dimensional menu item to 3-dimensional.  Turn the frame\n\
on by pressing `Frame'.  Set the input distribution to rectangle.\n\
Using the sigma/alpha method and the parameters described above,\n\
press `Init Neurons' then `Simulate' four times.  Now press `Spin'.\n\
\n\
TSP Example:\n\
\n\
	Set the network geometry to ring, the input distribution\n\
to city and the learning method to sigma/alpha.  Now set XState to\n\
25 with YState and ZState equal to 1.  Set Sigma Decay to 0.1,\n\
sigma to 5, alpha to 1 and Decay Time to 5000.  Press `Init\n\
Neurons' and run it for 8000 iterations.  This does not `solve'\n\
the TSP, rather it shows what is possible without any special\n\
modification to the network.\
"
};
