
/*
 *	Help Window
 */

#include <stdio.h>
#include <X11/Intrinsic.h>	/* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include "map.h"
#include "hlp.h"

extern	Widget	toplevel;
extern	XStuff	X;
extern	void	display_message(), show_text();

int	help_window_open = FALSE;
int	open_help_window();
void	close_help_window(), menu_select();
Widget	help_scroll_win, help_toplevel, menu_form, menu_w;

char	*help_menu[] = {
	"  Getting Started   ",
	"Variable Definitions",
	"  State Variables   ",
	"    Menu Choices    ",
	"  Button Functions  ",
	"  Display Buttons   ",
	"   Some Examples    "
};

int
open_help_window()
{
	Widget	tmp1, tmp2, outer, entry, close_form, close_w;
	static	Arg	menuargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL
	};
	static	Arg	mbargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNvertDistance,	(XtArgVal)0,
		XtNborderWidth,		(XtArgVal)0
	};
	static	Arg	closeargs[] = {
		XtNfromVert,		(XtArgVal)NULL,
		XtNfromHoriz,		(XtArgVal)NULL
	};
	static	Arg	scrollwinargs[] = {
		XtNheight,		(XtArgVal)400,
		XtNwidth,		(XtArgVal)520,
		XtNfromVert,		(XtArgVal)NULL,
		XtNscrollVertical,	(XawTextScrollMode)XawtextScrollWhenNeeded
	};
	int	i;

	if (help_window_open)
		return FALSE;
	help_window_open = TRUE;
	help_toplevel = XtCreatePopupShell("Help Window", topLevelShellWidgetClass, toplevel, NULL, 0);
	outer = XtCreateManagedWidget("outer", formWidgetClass, help_toplevel, NULL, 0);

	help_scroll_win = XtCreateManagedWidget(" ", asciiTextWidgetClass, outer, scrollwinargs,
						XtNumber(scrollwinargs));
	show_text(help_scroll_win, help_msg[0]);

	menuargs[1].value = (XtArgVal)help_scroll_win;
	menu_form = XtCreateManagedWidget("menu", formWidgetClass, outer, menuargs,
						XtNumber(menuargs));
	mbargs[0].value = (XtArgVal)NULL;
	for (i=0; i<XtNumber(help_menu); i++) {
		char *item = help_menu[i];
		entry = XtCreateManagedWidget(item, commandWidgetClass, menu_form, mbargs,
						XtNumber(mbargs));
		XtAddCallback(entry, XtNcallback, menu_select, (XtPointer)i);
		mbargs[0].value = (XtArgVal)entry;
	}

	closeargs[0].value = (XtArgVal)menu_form;
	closeargs[1].value = (XtArgVal)help_scroll_win;
	close_w = XtCreateManagedWidget("Close", commandWidgetClass, outer, closeargs,
						XtNumber(closeargs));
	XtAddCallback(close_w, XtNcallback, close_help_window, 0);

	XtRealizeWidget(help_toplevel);
	XtPopup(help_toplevel, XtGrabNone);
	return TRUE;
}

void
close_help_window()
{
	XtDestroyWidget(help_toplevel);
	help_window_open = FALSE;
}

void
menu_select(w, number, client_data)
Widget		w;
XtPointer	number, client_data;
{
	show_text(help_scroll_win, help_msg[(int)number]);
}
