
/*
 *	Button Functions
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>	/* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>
#include "map.h"

extern	double	randm(), normal();
extern	int	get_seed(), open_new_window(), open_help_window();
extern	void	display_message(), init_state(), init_seed(), polypoint_test(),
		learn(), update_map(), get_parameters(), get_once_parameters(), draw_frame();
extern	double	alpha, alpha_decay, sigma, radius;
extern	int	array, distribution, learning_rule, faults, neurons, dimension, xstate, ystate, zstate,
		window, fault_column;
extern	int	stx[MAXN], sty[MAXN], stz[MAXN], fault_loc[MAXN], x_angle[MAX_WINDOWS],
		z_angle[MAX_WINDOWS];
extern	Widget	array_w, distrib_w, lr_w, ttd_w, if_w;
extern	XStuff	X;
extern	char	*array_menu[], *distrib_menu[], *lr_menu[], *ttd_menu[], *if_menu[];

void	quit(), simulate(), init_neurons(), points(), array_select(), distrib_select(), lr_select(),
	inject_fault(), ttd_select(), new_ttd_window(), online_help(), if_select();
char	buf[80];
double	true_alpha, true_sigma, true_radius;
int	distrib_seed	= 1,
	neuron_seed	= 1,
	fault_seed	= 1,
	n		= 0,
	fault_type	= GAUSIAN,
	iterations	= 500,
	map_update	= 50,
	decay_time	= 2000,
	frame_on	= FALSE,
	inverted	= FALSE,
	iter		= -1;

void
init_neurons(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	get_once_parameters();
	init_seed(neuron_seed);
	init_state();
	init_seed(distrib_seed);
	update_map();
	display_message("Neurons Initialized");
	iter = 0;
	n = 0;
}

void
simulate(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	double	ac;
	int	i;

	if (iter < 0)
		init_neurons(w, call_data, client_data);
	get_parameters();
	true_alpha = alpha;
	true_sigma = sigma;
	true_radius = radius;
	for (i=0; i<iterations; i++) {
		if ((distribution == CITY) && ((iter % neurons) == 0))
			init_seed(distrib_seed);
		iter++;
		if (alpha_decay != 1.0) {
			ac = n / (double)decay_time;
			alpha = true_alpha * pow(0.04, ac);
			sigma = true_sigma * pow(alpha_decay, ac);
			radius = true_radius * (1.0 - ac) + 1.0;
			n++;
		}
		learn();
		if ((iter % map_update) == 0)
			update_map();
	}
	if ((iter % map_update) != 0)
		update_map();
	sprintf(buf, "%d Iterations Completed", iter);
	display_message(buf);
}

void
points(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	int 	i;

	for (i=0; i<window; i++)
		polypoint_test(i);
	display_message("10000 Points Displayed");
}

void
quit(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
	exit(0);
}

void
array_select(w, number, client_data)
Widget		w;
XtPointer	number, client_data;
{
	static	Arg	args[1];

	array = (int)number;
	XtSetArg(args[0], XtNlabel, array_menu[array]);
	XtSetValues(array_w, args, (Cardinal)1);
}

void
distrib_select(w, number, client_data)
Widget		w;
XtPointer	number, client_data;
{
	static	Arg	args[1];

	distribution = (int)number;
	XtSetArg(args[0], XtNlabel, distrib_menu[distribution]);
	XtSetValues(distrib_w, args, (Cardinal)1);
}

void
lr_select(w, number, client_data)
Widget		w;
XtPointer	number, client_data;
{
	static	Arg	args[1];

	learning_rule = (int)number;
	XtSetArg(args[0], XtNlabel, lr_menu[learning_rule]);
	XtSetValues(lr_w, args, (Cardinal)1);
}

void
if_select(w, number, client_data)
Widget		w;
XtPointer	number, client_data;
{
	static	Arg	args[1];

	fault_type = (int)number;
	XtSetArg(args[0], XtNlabel, if_menu[fault_type]);
	XtSetValues(if_w, args, (Cardinal)1);
}

void
inject_fault(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	int	loc, x, y;

	if (faults >= neurons-2)
		display_message("Only 1 neuron left, no fault injected");
	else {
		if (fault_type == HALF) {
			if (fault_column >= ystate-1) {
				display_message("Only one column left, no faults injected");
				return;
			}
			loc = fault_column * ystate;
			for (x=0; x<xstate; x++) {
				if (fault_loc[loc] == 0) {
					faults++;
					fault_loc[loc] = 1;
				}
				loc++;
			}
			fault_column++;
			sprintf(buf, "All neurons in column %d are dead", fault_column);
			display_message(buf);
		} else {
			distrib_seed = get_seed();
			init_seed(fault_seed);
			do {
				if (fault_type == GAUSIAN) {
					do {
						x = normal() * 0.1 * xstate + ystate / 2;
					} while ((x < 0) || (x >= xstate));
						do {
						y = normal() * 0.1 * ystate + ystate / 2;
					} while ((y < 0) || (y >= ystate));
					loc = x + y * ystate;
				} else
					loc = randm() * neurons;
			} while (fault_loc[loc]);
			if (array == LINEAR)
				sprintf(buf, "Fault injected at neuron %d", loc);
			else
				sprintf(buf, "Fault injected at location %d, %d", stx[loc], sty[loc]);
			display_message(buf);
			faults++;
			fault_loc[loc] = 1;
			fault_seed = get_seed();
			init_seed(distrib_seed);
		}
		update_map();
	}
}

void
ttd_select(w, number, client_data)
Widget		w;
XtPointer	number, client_data;
{
	static	Arg	args[1];

	dimension = (int)number;
	XtSetArg(args[0], XtNlabel, ttd_menu[dimension]);
	XtSetValues(ttd_w, args, (Cardinal)1);
}

void
new_ttd_window(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	if (open_new_window())
		display_message("New Window Opened");
	else
		display_message("Maximum number of display windows already open");
}

void
online_help(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	if (open_help_window())
		display_message("Help Window Opened");
	else
		display_message("The help window is already open.");
}

void
spin_objects(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	int	i, j;

	if (iter < 0)
		display_message("There is no object to spin!");
	else
		for (i=0; i<72; i++) {
			for (j=0; j<window; j++) {
				x_angle[j] += 5;
				if (x_angle[j] >= 360)
					x_angle[j] -= 360;
				z_angle[j] += 5;
				if (z_angle[j] >= 360)
					z_angle[j] -= 360;
				calc_coefficients(j);
			}
			update_map();
		}
}

void
toggle_frame(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	int	i;

	frame_on = 1 - frame_on;
	if (frame_on) {
		for (i=0; i<window; i++)
			draw_frame(i);	
	} else
		update_map();
}

void
invert_windows(w, call_data, client_data)
Widget		w;
XtPointer	call_data, client_data;
{
	inverted = 1 - inverted;
	invert_background();
}
