
/*
 *	Button Functions
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>	/* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include "map.h"

extern	Widget	message, ttd_canvas[MAX_WINDOWS];
extern	XStuff	X;
extern	double	zspace;
extern	int	dimension, window, distribution, frame_on, distrib_seed, neurons;
extern	void	update_ttd_window();

void	display_message(), show_text(), polypoint_test(), get_distribution(), invert_background(),
	get_window_size(), draw_frame();

void
show_text(w, m)
Widget		w;
char		*m;
{
	static	Arg	args[1];

	XtSetArg(args[0], XtNstring, m);
	XtSetValues(w, args, (Cardinal)1);
}

void
display_message(m)
char		*m;
{
	static	Arg	args[1];

	XtSetArg(args[0], XtNlabel, m);
	XtSetValues(message, args, (Cardinal)1);
}

void
get_window_size(w, dX, dY)
Widget	w;
int	*dX, *dY;
{
	static	Arg	winargs[] = {
		XtNwidth,	(XtArgVal)NULL,
		XtNheight,	(XtArgVal)NULL
	};

	winargs[0].value = (XtArgVal)NULL;
	winargs[1].value = (XtArgVal)NULL;
	XtGetValues(w, winargs, XtNumber(winargs));
	*dX = winargs[0].value;
	*dY = winargs[1].value;
}

void
polypoint_test(w)
int	w;
{
	XPoint	*points;
	int	num_points, i, dX, dY;
	double	x, y, z, pX, pY;

	get_window_size(ttd_canvas[w], &dX, &dY);
	num_points = 10000;
	if (distribution == CITY) {
		init_seed(distrib_seed);
		num_points = neurons;
	}
	points = (XPoint *)malloc(sizeof(XPoint) * num_points);
	for (i=0; i<num_points; i++) {
		get_distribution(&x, &y, &z);
		calc_perspective(w, x, y, z, &pX, &pY);
		points[i].x = pX * dX;
		points[i].y = pY * dY;
	}
	XDrawPoints(X.dpy, X.wins[w], X.gc, points, num_points, CoordModeOrigin);
	free(points);
}

void
update_map()
{
	int	i;

	for (i=0; i<window; i++)
		update_ttd_window(i);
}

void
draw_frame(w)
int	w;
{
	double	pX, pY, qX, qY, hz;
	int	dX, dY;
	XPoint	*coord;

	if (!frame_on)
		return;
	get_window_size(ttd_canvas[w], &dX, &dY);
	coord = (XPoint *)malloc(sizeof(XPoint) * 10);
	switch (dimension) {
	case DIMENSION2:
		switch (distribution) {
		case RECTANGLE:
		case GAUSSIAN:
		case CLUSTERED:
			calc_perspective(w, 0.0, 0.0, 0.5, &pX, &pY);
			coord[0].x = pX * dX;
			coord[0].y = pY * dY;
			calc_perspective(w, 0.0, 1.0, 0.5, &pX, &pY);
			coord[1].x = pX * dX;
			coord[1].y = pY * dY;
			calc_perspective(w, 1.0, 1.0, 0.5, &pX, &pY);
			coord[2].x = pX * dX;
			coord[2].y = pY * dY;
			calc_perspective(w, 1.0, 0.0, 0.5, &pX, &pY);
			coord[3].x = pX * dX;
			coord[3].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5, &pX, &pY);
			coord[4].x = pX * dX;
			coord[4].y = pY * dY;
			XDrawLines(X.dpy, X.wins[w], X.gcd, coord, 5, CoordModeOrigin);
			break;
		case TRIANGLE:
			calc_perspective(w, 0.0, 0.0, 0.5, &pX, &pY);
			coord[0].x = pX * dX;
			coord[0].y = pY * dY;
			calc_perspective(w, 1.0, 0.5, 0.5, &pX, &pY);
			coord[1].x = pX * dX;
			coord[1].y = pY * dY;
			calc_perspective(w, 0.0, 1.0, 0.5, &pX, &pY);
			coord[2].x = pX * dX;
			coord[2].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5, &pX, &pY);
			coord[3].x = pX * dX;
			coord[3].y = pY * dY;
			XDrawLines(X.dpy, X.wins[w], X.gcd, coord, 4, CoordModeOrigin);
			break;
		}
		break;
	case DIMENSION3:
		switch (distribution) {
		case RECTANGLE:
			hz = zspace * 0.5;
			calc_perspective(w, 0.0, 0.0, 0.5 - hz, &pX, &pY);
			coord[0].x = pX * dX;
			coord[0].y = pY * dY;
			calc_perspective(w, 0.0, 1.0, 0.5 - hz, &pX, &pY);
			coord[1].x = pX * dX;
			coord[1].y = pY * dY;
			calc_perspective(w, 1.0, 1.0, 0.5 - hz, &pX, &pY);
			coord[2].x = pX * dX;
			coord[2].y = pY * dY;
			calc_perspective(w, 1.0, 0.0, 0.5 - hz, &pX, &pY);
			coord[3].x = pX * dX;
			coord[3].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5 - hz, &pX, &pY);
			coord[4].x = pX * dX;
			coord[4].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5 + hz, &pX, &pY);
			coord[5].x = pX * dX;
			coord[5].y = pY * dY;
			calc_perspective(w, 0.0, 1.0, 0.5 + hz, &pX, &pY);
			coord[6].x = pX * dX;
			coord[6].y = pY * dY;
			calc_perspective(w, 1.0, 1.0, 0.5 + hz, &pX, &pY);
			coord[7].x = pX * dX;
			coord[7].y = pY * dY;
			calc_perspective(w, 1.0, 0.0, 0.5 + hz, &pX, &pY);
			coord[8].x = pX * dX;
			coord[8].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5 + hz, &pX, &pY);
			coord[9].x = pX * dX;
			coord[9].y = pY * dY;
			XDrawLines(X.dpy, X.wins[w], X.gcd, coord, 10, CoordModeOrigin);
			calc_perspective(w, 0.0, 1.0, 0.5 - hz, &pX, &pY);
			calc_perspective(w, 0.0, 1.0, 0.5 + hz, &qX, &qY);
			XDrawLine(X.dpy, X.wins[w], X.gcd, (int)(pX*dX), (int)(pY*dY),
							   (int)(qX*dX), (int)(qY*dY));
			calc_perspective(w, 1.0, 1.0, 0.5 - hz, &pX, &pY);
			calc_perspective(w, 1.0, 1.0, 0.5 + hz, &qX, &qY);
			XDrawLine(X.dpy, X.wins[w], X.gcd, (int)(pX*dX), (int)(pY*dY),
							   (int)(qX*dX), (int)(qY*dY));
			calc_perspective(w, 1.0, 0.0, 0.5 - hz, &pX, &pY);
			calc_perspective(w, 1.0, 0.0, 0.5 + hz, &qX, &qY);
			XDrawLine(X.dpy, X.wins[w], X.gcd, (int)(pX*dX), (int)(pY*dY),
							   (int)(qX*dX), (int)(qY*dY));
			break;
		case TRIANGLE:
			hz = zspace * 0.5;
			calc_perspective(w, 0.0, 0.0, 0.5 - hz, &pX, &pY);
			coord[0].x = pX * dX;
			coord[0].y = pY * dY;
			calc_perspective(w, 1.0, 0.5, 0.5, &pX, &pY);
			coord[1].x = pX * dX;
			coord[1].y = pY * dY;
			calc_perspective(w, 0.0, 1.0, 0.5 - hz, &pX, &pY);
			coord[2].x = pX * dX;
			coord[2].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5 - hz, &pX, &pY);
			coord[3].x = pX * dX;
			coord[3].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5 + hz, &pX, &pY);
			coord[4].x = pX * dX;
			coord[4].y = pY * dY;
			calc_perspective(w, 1.0, 0.5, 0.5, &pX, &pY);
			coord[5].x = pX * dX;
			coord[5].y = pY * dY;
			calc_perspective(w, 0.0, 1.0, 0.5 + hz, &pX, &pY);
			coord[6].x = pX * dX;
			coord[6].y = pY * dY;
			calc_perspective(w, 0.0, 0.0, 0.5 + hz, &pX, &pY);
			coord[7].x = pX * dX;
			coord[7].y = pY * dY;
			XDrawLines(X.dpy, X.wins[w], X.gcd, coord, 8, CoordModeOrigin);
			calc_perspective(w, 0.0, 1.0, 0.5 - hz, &pX, &pY);
			calc_perspective(w, 0.0, 1.0, 0.5 + hz, &qX, &qY);
			XDrawLine(X.dpy, X.wins[w], X.gcd, (int)(pX*dX), (int)(pY*dY),
							   (int)(qX*dX), (int)(qY*dY));
			break;
		}
		break;
	}
}

void
invert_background()
{
	int		i;
	unsigned long	bg, fg;

	bg = X.background;
	fg = X.foreground;
	X.background = fg;
	X.foreground = bg;
	X.gcv.background = fg;
	X.gcv.foreground = bg;
	XSetBackground(X.dpy, X.gc, fg);
	XSetForeground(X.dpy, X.gc, bg);
	XSetBackground(X.dpy, X.gcd, bg);
	XSetForeground(X.dpy, X.gcd, fg);
	for (i=0; i<window; i++)
		XSetWindowBackground(X.dpy, XtWindow(ttd_canvas[i]), fg);
	update_map();
}
