//*************************************************************************
//
// Header file for C++ object to handle Forth dictionary words
//
// BJ McDonald
//
//*************************************************************************


#define	MAXBUFFER	256


enum wordtype {
	number	= 0,				// this word is a number
	builtin	= 1,				// builtin word
	defined	= 2,				// user defined word
	variable= 3,				// user defined variable
	constant= 4,				// user defined constant
	array	= 5,				// user defined array
	node	= 6,				// user defined node
	layer	= 7,				// user defined layer
	weight	= 8,				// user defined weight
};


struct packedchar {     		// one of the 3 possible types of token
	unsigned int p0 : 8;		// char pos #1
	unsigned int p1 : 8;		// char pos #2
	unsigned int p2 : 8;		// char pos #3
	unsigned int p3 : 8;		// char pos #4
};


struct identifier {				// one of the 4 possible types of token
	unsigned int z  : 16;		// word code
	unsigned int n  : 8;		// number of following tokens with data
	unsigned int x  : 8;		// identifier code
};


union token {					// token constists of ONE of the following
	identifier id;				// either an identifier
	packedchar pc;				// or a packed char structure
	long       num;				// or a long integer
};

struct word {
	word	*prev;				// pointer to previously defined word in list
	char	*name;				// pointer to the name of the word
	int		code;				// some function code
	char	delim;				// some delimitor character
	enum	wordtype type;		// what is the type of this word
	long	data;				// pointer to parameter data
	token	*tokens;			// pointer to token stream
	long	NumTokens;			// the number of tokens
	void	(*funcode)();		// address of code
};


class wordlist {
	word	*ListTail;			// Pointer to tail of list
	int		NumInList;			// Number of words in the list
	word	**PtrIndex;			// Index array of word pointers
	int		MaxPtrIndex;		// Max number in pointer index
	void 	Bomb(char *errstr);	// general error catcher
	void 	Error(char *s1, char *s2);	// more sophisticated error function

public:
	wordlist(int num=200);		// Wordlist constructor
	~wordlist();				// Wordlist destructor
	word *Findword(int num);	// Returns address of word
	word *Findword(char *nme);
	void Addword(char *nme,int delim,token *tkn,int ntok);		// add word with stream of tokens
	void Addword(char *nme,int delim,void (*func)());
	void Addword(word *newword);// pointer to the data
	int  Searchword(char *name);// return number of word of name nme
	void Execword(int num);		// execute
	void Forgetword(int num);	// forget
	void Forgetword(char *nme);
	void Forgetsince(int num);
	void Forgetsince(char *nme);
	word *Tail(void);			// returns the last word in the list
};

