// Methods for the wordlist class


#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "wordlist.h"



void wordlist::Bomb(char *errstr)
{
	cputs(errstr);
	cputs("\r\n");
}



//
// error exit routine - somewhat more complex
//

void wordlist::Error(char *str1, char *str2)
{
	char buffer[MAXBUFFER];

	sprintf(buffer,str1,str2);
	Bomb(buffer);
}



wordlist::wordlist(int num)
{
	NumInList=0;
	ListTail=(word *)NULL;
	PtrIndex = new word*[num];				// Allocate the space
	if (PtrIndex==(word **)NULL)			// Was it successful ?
		Bomb("Can't Construct wordlist.");	// No - bomb out

	MaxPtrIndex=num;
}

wordlist::~wordlist()
{
	 delete PtrIndex;

	word *sword=ListTail;
	word *pword=sword->prev;

	while(sword) {
		delete sword;
		sword=pword;
		pword=pword->prev;
	}
}

void wordlist::Addword(char *nme, int delim, token *tkn, int ntok)
{
	word *newword=new word;
	if (!newword)
		Error("Could not assign word: ",nme);

	newword->name = new char[strlen(nme)+2];
	if (!newword->name) {
		Error("Could not assign word: ",nme);
		delete newword;
	}

	newword->type=defined;				// This is a defined type word
	strcpy(newword->name,nme);			// copy the name

	newword->code=ListTail->code+1;		// Set-up the code
	newword->prev=ListTail;				// Link into the list
	newword->delim=delim;				// Set-up the delim character
	newword->tokens=tkn;				// Point the word to the tokens
	newword->NumTokens=ntok;			// The number of tokens

	ListTail=newword;					// New word is the tail

	if(NumInList<MaxPtrIndex)			// If possible add the
		PtrIndex[NumInList]=newword;	// newwords pointer to the index

	NumInList++;						// One more word in list
}


void wordlist::Addword(char *nme, int delim, void (*func)())
{
	word *newword=new word;
	if (!newword)
		Error("Could not assign word: ",nme);

	newword->name = new char[strlen(nme)+2];
	if (!newword->name) {
		Error("Could not assign word: ",nme);
		delete newword;
	}
	newword->type=builtin;
	strcpy(newword->name,nme);

	if(NumInList>0) {
		newword->code=ListTail->code+1;
		newword->prev=ListTail;
	} else {
		newword->code=0;
		newword->prev=NULL;
	}

	newword->funcode=func;
	newword->delim=delim;

	ListTail=newword;

	if(NumInList<MaxPtrIndex)
		PtrIndex[NumInList]=newword;

	NumInList++;						// Indicate a new word in list
}


void wordlist::Addword(word *newword)
{
	word *nword = new word;				// create a new word

	*nword=*newword;					// copy reference to new

	if (!nword)
		Error("Could not assign word: ",newword->name);

	nword->code=ListTail->code+1;
	nword->prev=ListTail;

	ListTail=nword;

	if(NumInList<MaxPtrIndex)
		PtrIndex[NumInList]=nword;

	NumInList++;
}


int wordlist::Searchword(char *nme)
{

	for(word *sword=(word *)ListTail;
		(sword!=NULL)&&(strcmp(sword->name,nme)!=0);
		sword=sword->prev);				// locate the word

	if (sword==(word *)NULL)
		return -1;
	else
		return sword->code;
}


word *wordlist::Findword(int num)
{
	if (num<0||num>=NumInList)
		Bomb("Word number out of bounds");

	if (num<MaxPtrIndex)
		return PtrIndex[num];
	else {
		for(word *sword=(word *)ListTail;
			(sword!=NULL)&&sword->code!=num;
			sword=sword->prev);				// locate the word

		return sword;
	}
}


word *wordlist::Findword(char *nme)
{
	for(word *sword=(word *)ListTail;
		(sword!=NULL)&&(strcmp(sword->name,nme)!=0);
		sword=sword->prev);				// locate the word

		return sword;
}



void wordlist::Execword(int num)
{
	if(num>=0&&num<MaxPtrIndex)
		(PtrIndex[num]->funcode)();
	else {
		word *eword=Findword(num);
		(eword->funcode)();
	}
}


void wordlist::Forgetword(int num)
{
	word *dword=NULL;

	if(num==NumInList-1){					// Forget the list tail
		dword=ListTail;
		ListTail=ListTail->prev;			// Unlink the word
	} else {
		word *sword=Findword(num+1);

		if(sword==(word *)NULL||sword->type==builtin){
			Bomb("Could not forget word");
			return;
		}

		dword=sword->prev;
		sword->prev=dword->prev;			// unlink word to be forgotten

		for(word *lword=(word *)ListTail;
			lword!=sword;
			lword=lword->prev) {			// locate the word

				lword->code--;				// correct the code number
				if(lword->code<MaxPtrIndex)
					PtrIndex[lword->code]=lword;
			}
	}

	NumInList--;

	delete dword->name;
	if (dword->type==defined) delete [dword->NumTokens]dword->tokens;
	delete dword;

}



void wordlist::Forgetsince(int num)
{
	word *dword=ListTail;

	while (dword->code!=num||dword->type!=builtin) {
		delete dword->name;
		if (defined) delete dword->tokens;	// release token memory
		dword=dword->prev;
		NumInList--;
	}
	ListTail=dword;

}

void wordlist::Forgetsince(char *nme)
{
	int num=Searchword(nme);
	if (num==-1) Error("Unknown word: ",nme);
	else Forgetsince(num);
}



void wordlist::Forgetword(char *nme)
{
	int num=Searchword(nme);				// locate the word to delete
	if(num==-1) Error("Unknown word: ",nme);
	else Forgetword(num);					// forget the word
}

word *wordlist::Tail() {return ListTail;}