//***************************************************************************
// Header file for class Threshold which implements a artificial neuron's
// thresholding function.  _Threshold_ is designed so that digital approx-
// mations of an ideal threshold function and the effect of resolution
// limits with decreasing wordlengths of the data in the recall mode.
// From this it is then possible to optimise the number of bits per neuron
// necessary to perform correctly in an application.
//
// Version  :Date  		:time	   	:description
// 0.1		:27/6/91	:13h50		:First entry
// 0.2		:11/9/91	:09h10		:Name changes and massaging
//
//
//***************************************************************************

#include <math.h>

class Threshold {					// C++
	int 	IsDigital;				// = 1 when simulating digital systems
	int 	InputBits;				// # of bits input data to function
	int 	OutputBits;				// # of bits output data to function
	long 	*LookUpTable;			// Ptr to an array of output values
	int		Slope;					// Adjustment to sigmoid function
	void	MakeTable(int In, int Out);		// Make the look-up table
	void	FreeTable(void);		// Free the look-up table
public:
	Threshold(int InBits=0,int OutBits=0);	// constructor.  Default to non-digital.
	~Threshold();					// destructor
	long 	T(int num);				// digital transfer function
	float	T(float num);			// continuous transfer function
	float	Tp(float num);			// Derivative of transfer function
	void	SetDigital(int InBits, int Outbits);
									// Set the digital emulation specs
};
