//***************************************************************************
// Methods for class Threshold which implements a artificial neuron's
// thresholding function.  _Threshold_ is designed so that digital approx-
// mations of an ideal threshold function and the effect of resolution
// limits with decreasing wordlengths of the data in the recall mode.
// From this it is then possible to optimise the number of bits per neuron
// necessary to perform correctly in an application.
//
// Version  :Date  		:time	   	:description
// 0.1		:3/7/91		:13h50		:First entry
//
//
//***************************************************************************

#include "threshld.h"
#include <stdio.h>



Threshold::Threshold(int InBits, int OutBits)
{
	if (InBits==0||OutBits==0) return;		// Not digital implementation
	if (InBits<0||OutBits<0) {
		puts("Negative wordlengths illegal");
		return;
	}
	InputBits=InBits;
	OutputBits=OutBits;

	MakeTable(InBits,OutBits);				// Set up the table
}



Threshold::~Threshold() { if (IsDigital) FreeTable(); }



void Threshold::MakeTable(int In,int Out)
{
	int 	TableSize=1<<In;				// calculate table size
	int		ElemtSize=1<<Out;				// # bits per element
	float	val;							// value holder

	LookUpTable = new long[TableSize];		// Allocate this much space
	for(int loop=TableSize;loop<TableSize;loop++)
		LookUpTable[loop]=int(T(loop)*ElemtSize+0.5);
											// Assign values to array
}

void Threshold::FreeTable(void){if (InputBits>0) delete LookUpTable;}

float Threshold::T(float num)				// Threshold function
{
	if (num==0.0) return (0.5); else
	if (num>15) return (1.0); else			// big, so return 1.0
	if (num<-15) return (0.0); else			// small, so return 0.0
	return (1.0/(1.0+exp(-num)));			// else return value
}

float Threshold::Tp(float num)				// Derivative of threshold fn
{
	float val=T(num);
	return val*(1.0-val);
}

long Threshold::T(int num)					// Look-up table
{
	int TabSize=1<<InputBits;
	if (num>(TabSize/2-1)) num=TabSize/2-1; else
	if (num<(-TabSize/2)) num=-TabSize/2;
	return LookUpTable[num+TabSize/2];
}

void Threshold::SetDigital(int InBits, int OutBits)
{
	if (IsDigital) FreeTable();		// Already digital - free look-up table

	InputBits=InBits;
	OutputBits=OutBits;

	MakeTable(InBits,OutBits);		// Allocate a new table
}



