//***************************************************************************
//
// program: matrix.h
// Header file for class Matrix which is a stripped down float matrix handler
//
//
//***************************************************************************

class Matrix {
	int		rows;
	int		columns;
	void	MemAlloc(int r, int c);			// Allocates the memory
public:
	float	**data;					// pointer to matrix data
	Matrix(void);					// Do nothing constructor
	Matrix(int r, int c);			// Constructor for r x c matrix
	Matrix(int r);					// Constructor for r x r matrix
	~Matrix();						// Destructor for matrix
	void Make(int r, int c);		// Make a new r x c matrix
	void Make(int r);				// Make a new r x r matrix
	void Free(void);				// Free the alloc'd memory, etc
	void Set(int r, int c, float x);// Set (r,c) to value x
	float Read(int r, int c);		// Read value at (r,c)
};
