//***************************************************************************
//
// program: matrix.h
// Methods for class Matrix which is a stripped down float matrix handler
//
//
//***************************************************************************

#include "matrix.h"
#include <stdio.h>


void Matrix::MemAlloc(int r, int c) {    // Allocate the memory
	int flag=0;						// keeps track of allocations

	if (r<0||c<0) {
		puts("Illegal number of rows/columns.");
		return;
	}

	if ((data=new float*[r])!=NULL)
		for(int i=0;i<r;i++)
			data[i]=new float[c];
	else
		flag=1;

	if (flag) Free();				// Any allocation problems - free memory

	columns=c;						// do assigns
	rows=r;

}


Matrix::Matrix(void) {				// Do-nothing constructor
	rows=0;
	columns=0;
};


Matrix::Matrix(int r, int c) {		// Constructs a r x c matrix
	MemAlloc(r,c);					// Allocate the memory
}


Matrix::Matrix(int r){MemAlloc(r,r);}	// Constructs a square matrix


void Matrix::Make(int r, int c){

	if(columns>0||rows>0) Free();

	MemAlloc(r,c);
}

void Matrix::Make(int r) {

	if(columns>0||rows>0) Free();

	MemAlloc(r,r);
}


void Matrix::Free() {				// De-allocates all memory

	for (int i=0;i<columns;i++)
		delete [rows]data[i];

	delete [columns]data;

	columns=0;						// No columns or rows !!
	rows=0;
}


Matrix::~Matrix(){Free();}			// Vanilla destructor



