#include "lstack.h"

lstack::lstack(int num)
{
	data=new long[num];

	if(!data) err=1;				// could not assign space
	else {
		tos=0;
		max=num;
	}
}

lstack::~lstack(){delete data;}

void lstack::drop()
{
	if(tos<=0) err=2;
	else --tos;
}


long lstack::size() {return tos;}

void lstack::look()
{
	long num=pop();
	if(num<=0||num>tos-1) return;
	else push(data[num-1]);
}

void lstack::pushtos()
{
	push(tos);
}

void lstack::swap()
{
	if (tos<=1) err=2;
	else {
		long temp=data[tos-1];
		data[tos-1]=data[tos-2];
		data[tos-2]=temp;
	}
}

long lstack::pop()
{
	if (tos<=0) err=2;				// stack underflow
	else return data[--tos];
}


void lstack::push(long num)
{
	if (tos>=max) err=3;			// stack overflow
	else data[tos++]=num;
}


long lstack::peek(){
	if (tos<=0) err=4;				// stack empty
	else return data[tos-1];
}

float lstack::fpop()
{
	if (tos<=0) {err=5;return 0;}
	else return  *(float *)&data[--tos];
}

void lstack::fpush(float num)
{
	if (tos>=max) err=6;			// stack overflow
	else {
		float *x=(float *)&data[tos++];
		*x=num;
	}
}


float lstack::fpeek(){
	if (tos<=0) {err=7;return 0;}	// stack empty
	else return *(float *)&data[tos-1];
}


void lstack::f2i(void) {          	// float -> integer
	float x=fpop();
	long i = (long)x;
	push(i);
}


void lstack::i2f(void) {			// integer -> float
	long i = pop();
	float f = (float)i;
	fpush(f);
}


char *lstack::errstring(){
	int oerr=err;
	err=0;
	if(oerr==0) return "ok";
	if(oerr==1) return "could not assign stack";
	if(oerr==2) return "stack underflow (int)";
	if(oerr==3) return "stack overflow (int)";
	if(oerr==4) return "stack empty (int)";
	if(oerr==5) return "stack underflow (float)";
	if(oerr==6) return "stack overflow (float)";
	if(oerr==7) return "stack empty (float)";
}

int lstack::error(){return err;}

