//*******************************************************************
//
//		Header File For the Forth Class
//
//
//
//
//
//
//*******************************************************************

#include "lstack.h"
#include "wordlist.h"

//
// Standard definitions
//

#define 	MAXPSTACK	100		// Maximum size of parameter stack
#define		MAXRSTACK	50		// Maximum size of return stack
#define		MAXBUFFER	256		// used to nest commands
#define		FILBUFFER	1024	// Maximum size of file buffer
#define		MAXTOKEN	20		// Max size of returned tokens
#define		LINETOKEN	100		// max number of tokens in stream
#define		MAXWORDS	147		// Max number of builtin words




//
// Here come the vital class
//


class Forth {
//
// Private variables for Forth
//
	wordlist words;				// This is the forth word dictionary
	token	*ctoken;          	// current token being processed
	char 	*line;				// pointer to line to process
	char 	toke[MAXTOKEN];		// return word
	int		errcnd;				// Error code
	int 	loading;			// if g.t. 0 then loading file from disk
	long	scale;				// scale factor for conversions
//
// Private functions for Forth
//
	void	Interpret(void);	// Interpret the parsed word
	void	GetNextWord(void);	// get the next word from the input
	char	*GetTok(char term);	// token getter
	long	Number(char *name);	// if name valid number return else error
	int  	Pack(char terminal);// pack chars into ctoken 'til terminal hit
	char 	*Unpack(void);		// returns a string after unpacking ctoken
	void 	Tokenize();			// tokenize input line to ctoken stream
	void 	BuiltIn(word *exec);// perform builtin operation
public:
	lstack	p;					// parameter stack
	lstack	r;					// return stack

	Forth();					// The constructor
	~Forth();					// The destructor
	void	ExecLine(char *InStr);// Input Line to execute
	void	Bomb(char *errstr);	// general error catcher
	void	Error(char *s1, char *s2);// more sophisticated error function
	void	AddWord(int code);	// adds new word to the dictionary
	void	AddWord(char *nme,int delim,void (*func)());
								// To create the dictionary from new.
	void 	Tick(void);			// puts address of the next word on stack
	void 	IfStat(void);		// handle if-[else]conditionals
	void 	ThenStat(void);		// handle 'then' word
	void 	ExitStat(void);		// pops input string ptr from r stack
	void 	DoStat(void);		// interface for 'do' word
	void	LoopStat(void);		// interface for 'loop' word
	void	LoopPStat(void);	// interface for 'loop+' word
	void	BeginStat(void);	// interface for 'begin' word
	void	UntilStat(void);	// interface for 'until' word
	void	LoadStat(void);		// interface for 'load' word
	void	SaveStat(void);		// interface for 'save' word
	void	ListStat(void);		// interface for 'list' word
	void	DelimStat(void);	// interface for 'delim' word
	void	ForgetWord(void);	// interface for 'forget' word
	void	ForgetSince(void);	// interface for 'forsince' word
	void	f2i(void);			// float num to integer num
	void	i2f(void);			// integer num to float num
	void	SetData(void);		// Set a words data variable to ptos
	void	ReadData(void);	  	// Read words data variable to ptos
	int		ReadError(void);	// returns the latest error code
	char	*ReadLine(void);	// returns the line pointer
};