/***************************************************************************

 program:	ANNforth
 purpose:	programmable front-end for annsim
 version:	3.2
 module:	4thmain.c
 author:	BJ McDonald

***************************************************************************/

#include "forth.h"
#include "gen.h"

#include <stdio.h>

//
// Global variable definitions
//

Forth forth;


//
// Functions from main
//

void initwords()
{
	forth.AddWord("+",0,op1);
	forth.AddWord("-",0,op2);
	forth.AddWord("*",0,op3);
	forth.AddWord("/",0,op4);
	forth.AddWord("mod",0,op5);
	forth.AddWord(">",0,op6);
	forth.AddWord(">=",0,op7);
	forth.AddWord("<",0,op8);
	forth.AddWord("<=",0,op9);
	forth.AddWord("=",0,op10);
	forth.AddWord("<>",0,op11);
	forth.AddWord("and",0,op12);
	forth.AddWord("or",0,op13);
	forth.AddWord("not",0,op14);
	forth.AddWord("&",0,op15);
	forth.AddWord("|",0,op16);
	forth.AddWord("~",0,op17);
	forth.AddWord("<<",0,op18);
	forth.AddWord(">>",0,op19);
	forth.AddWord("dup",0,op20);
	forth.AddWord("swap",0,op21);
	forth.AddWord("tos",0,op22);
	forth.AddWord("drop",0,op23);
	forth.AddWord(">r",0,op24);
	forth.AddWord("<r",0,op25);
	forth.AddWord(".",0,op26);
	forth.AddWord("emit",0,op27);
	forth.AddWord(":",32,op28);
	forth.AddWord("variable",32,op29);
	forth.AddWord("constant",32,op30);
	forth.AddWord("'",32,op31);
	forth.AddWord("if",0,op32);
	forth.AddWord("else",0,op32);
	forth.AddWord("then",0,op33);
	forth.AddWord("do",0,op34);
	forth.AddWord("loop",0,op35);
	forth.AddWord("+loop",0,op36);
	forth.AddWord("begin",0,op37);
	forth.AddWord("until",0,op38);
	forth.AddWord(";",0,op39);
	forth.AddWord("!",0,op40);			// SetData()
	forth.AddWord("@",0,op41);			// ReadData()
	forth.AddWord("forget",32,op42);
	forth.AddWord("forgetsince",32,op43);
	forth.AddWord("list",0,op44);
	forth.AddWord("load",32,op47);
	forth.AddWord("delim",32,op48);
	forth.AddWord("input\"",34,op49);
	forth.AddWord("get\"",34,op50);
	forth.AddWord("h",0,op51);
	forth.AddWord("alloc",0,op52);
	forth.AddWord("free",0,op53);
	forth.AddWord(".\"",34,op54);
	forth.AddWord("cr",0,op55);
	forth.AddWord("i",0,op56);
	forth.AddWord("!\"",34,op57);
	forth.AddWord("quit",0,op58);
	forth.AddWord("nop",0,op59);
	forth.AddWord("look",0,op60);
	//
	// IO related words 100 -> 149
	//
	forth.AddWord("io_open",32,op100);		// IO stuff
	forth.AddWord("io_close",0,op101);
	forth.AddWord("io_eof",0,op102);
	forth.AddWord("io_getc",0,op103);
	forth.AddWord("io_putc",0,op104);
	forth.AddWord("io_flush",0,op105);
	forth.AddWord("io_read",0,op106);
	forth.AddWord("io_write",0,op107);
	forth.AddWord("io_seek",0,op108);
	forth.AddWord("io_tell",0,op109);
	forth.AddWord("stdin@",0,op110);
	forth.AddWord("stdout@",0,op111);
	//
	// MSDOS specific words 150 -> 199
	//
	forth.AddWord("atoi",0,op150);
	forth.AddWord("rand",0,op151);
	forth.AddWord("srand",0,op152);
	forth.AddWord("gotoxy",0,op153);
	forth.AddWord("window",0,op154);
	forth.AddWord("wherex",0,op155);
	forth.AddWord("wherey",0,op156);
	forth.AddWord("clr",0,op157);
	//
	// Floating pt words 200 -> 299
	//
	forth.AddWord("f2i",0,op200);
	forth.AddWord("i2f",0,op201);
	forth.AddWord("f+",0,op202);
	forth.AddWord("f-",0,op203);
	forth.AddWord("f*",0,op204);
	forth.AddWord("f/",0,op205);
	forth.AddWord("fabs",0,op206);
	forth.AddWord("fexp",0,op207);
	forth.AddWord("flog",0,op208);
	forth.AddWord("fsin",0,op209);
	forth.AddWord("fcos",0,op210);
	forth.AddWord("ftan",0,op211);
	forth.AddWord("fasin",0,op212);
	forth.AddWord("facos",0,op213);
	forth.AddWord("fatan",0,op214);
	forth.AddWord("f.",0,op215);
	forth.AddWord("f",32,op216);
	forth.AddWord("finput\"",34,op217);
	//
	// ANN stuff 300 -> 399
	//
	forth.AddWord("buildnet",0,op300);		// ann stuff
	forth.AddWord("freenet",0,op301);
	forth.AddWord("loadnet",32,op302);
	forth.AddWord("savenet",32,op303);
	forth.AddWord("loadweights",32,op304);
	forth.AddWord("saveweights",32,op305);
	forth.AddWord("loadtrains",32,op306);
	forth.AddWord("loadtests",32,op307);
	forth.AddWord("connectnode",0,op308);
	forth.AddWord("connectlayer",0,op309);
	forth.AddWord("train",0,op310);
	forth.AddWord("test",0,op311);
	forth.AddWord("!weightrange",0,op312);
	forth.AddWord("!SigPriOffset",0,op313);
	forth.AddWord("!epsilon",0,op314);
	forth.AddWord("!maxfactor",0,op315);
	forth.AddWord("!decay",0,op316);
	forth.AddWord("!splitepsilon",0,op317);
	forth.AddWord("@totalerror",0,op318);
	forth.AddWord("@didgradient",0,op319);
	forth.AddWord("@totalerrorbits",0,op320);
	forth.AddWord("@error",0,op321);
	forth.AddWord("@output",0,op322);
	forth.AddWord("@errorsum",0,op323);
	forth.AddWord("@numconns",0,op324);
	forth.AddWord("forward",0,op325);
	forth.AddWord("backward",0,op326);
	forth.AddWord("@weight",0,op327);
	forth.AddWord("!weight",0,op328);
	forth.AddWord("@units",0,op329);
	forth.AddWord("@inputs",0,op330);
	forth.AddWord("@hidden",0,op331);
	forth.AddWord("@outputs",0,op332);

}


// be nice and say hello

void introduction(void)
{
	puts("FORTH interpreter  V3.0              B McDonald");
	puts("Artificial Neural Network simulation extensions");
	puts("Copyright 1990,1991\n");
}



// This is it - the MAIN routine - not much to look izzit

main()
{
	char inbuffer[MAXBUFFER];		// assign a input buffer

	initwords();					// load in all the various built-in words
	introduction();					// say hello

	forth.ExecLine("load init.4th ");// the start-up file

	for(;;) {						// do forever ....
		gets(inbuffer);             // get a line from the console
		forth.ExecLine(inbuffer);	// and execute it now ...
	}
}
