//*************************************************************************
//
// program:	annforth
// purpose:	ANN simulator with forth interpreter
// version:	3.2
// module:	4thdefns.c
// purpose:	Interface code for the forth interpreter
// author:	BJ McDonald
// date:	28/2/1991
//
//*************************************************************************

#include "forth.h"
#include "ann.h"
#include "gen.h"


#include <string.h>
#include <stdlib.h>
#include <alloc.h>
#include <stdio.h>
#include <conio.h>

extern	Forth forth;
NeuralNet  	ann;



//
// builtin word's code performed by these functions
//


void dupstck(void) {op22();}
void op1(void) {forth.p.push(forth.p.pop()+forth.p.pop());}		// +
void op2(void) {forth.p.push(forth.p.pop()-forth.p.pop());}		// -
void op3(void) {forth.p.push(forth.p.pop()*forth.p.pop());}		// *
void op4(void) {forth.p.push(forth.p.pop()/forth.p.pop());}		// /
void op5(void) {forth.p.push(forth.p.pop()%forth.p.pop());}		// mod
void op6(void) {forth.p.push(forth.p.pop()>forth.p.pop());}		// >
void op7(void) {forth.p.push(forth.p.pop()>=forth.p.pop());}	// >=
void op8(void) {forth.p.push(forth.p.pop()<forth.p.pop());}		// <
void op9(void) {forth.p.push(forth.p.pop()<=forth.p.pop());}	// <=
void op10(void) {forth.p.push(forth.p.pop()==forth.p.pop());}	// =
void op11(void) {forth.p.push(forth.p.pop()!=forth.p.pop());}	// <>
void op12(void) {												// and
	long i=forth.p.pop();
	long j=forth.p.pop();
	forth.p.push(i&&j);
}
void op13(void) {												// or
	long i=forth.p.pop();
	long j=forth.p.pop();
	forth.p.push(i||j);
}
void op14(void) {forth.p.push(!forth.p.pop());}					// not
void op15(void) {forth.p.push(forth.p.pop()&forth.p.pop());}	// &
void op16(void) {forth.p.push(forth.p.pop()|forth.p.pop());}	// |
void op17(void) {forth.p.push(~forth.p.pop());}					// ~
void op18(void) {forth.p.push(forth.p.pop()<<forth.p.pop());}	// <<
void op19(void) {forth.p.push(forth.p.pop()>>forth.p.pop());};	// >>
void op20(void) {forth.p.push(forth.p.peek());}					// dup
void op21(void) {forth.p.swap();}			 					// swap
void op22(void)	{forth.p.pushtos();}							// tos
void op23(void)	{forth.p.drop();}								// drop
void op24(void) {forth.r.push(forth.p.pop());}					// >r
void op25(void) {forth.p.push(forth.r.pop());}					// <r
void op26(void) {												// .
	char str[20];
	long i=forth.p.pop();
	if (forth.p.error()) return;
	ltoa(i,str,10);
	if(!forth.ReadError()) cputs(str);
}
void op27(void) {putch((int)forth.p.pop());}					// emit
//
// Special forth words that link back into the forth class
//
void op28(void) {forth.AddWord(40);}							// :
void op29(void) {forth.AddWord(41);}							// variable
void op30(void) {forth.AddWord(45);}							// constant
void op31(void) {forth.Tick();}									// '
void op32(void) {forth.IfStat();}                               // if
void op33(void) {forth.ThenStat();}								// then
void op34(void) {forth.DoStat();}								// do
void op35(void) {forth.LoopStat();}								// loop
void op36(void) {forth.LoopPStat();}							// +loop
void op37(void) {forth.BeginStat();}							// begin
void op38(void) {forth.UntilStat();}							// until
void op39(void) {forth.ExitStat();}								// ;
void op40(void) {forth.SetData();}								// !
void op41(void) {forth.ReadData();}								// @
void op42(void) {forth.ForgetWord();}							// forget
void op43(void) {forth.ForgetSince();}							// forgetsince
void op44(void) {forth.ListStat();}								// list
void op47(void) {forth.LoadStat();}								// load
void op48(void) {forth.DelimStat();}							// delim
void op49(void) {												// input"
	char buffer[20];			// buffer to hold the input

	op54();						// Print out the quote

	gets(buffer);
	forth.p.push(atol(buffer));
}
void op50(void) {												// get
	forth.p.push((long)forth.ReadLine());
}
void op51(void) {forth.p.push((long)forth.ReadLine());}			// h
void op52(void) {												// alloc
	forth.p.push((long)malloc(forth.p.pop()));
}
void op53(void) {free((void *)forth.p.pop());}					// free
void op54(void) {cprintf(forth.ReadLine());}					// ."
void op55(void) {cputs("\r\n");}								// cr
void op56(void) {  												// i
	long i=forth.r.pop();
	forth.p.push(i);
	forth.r.push(i);
}
void op57(void) {system(forth.ReadLine());}						// !"

void op58(void) {												// quit
	clrscr();
	forth.Bomb("ANNforth aborted");
	exit(1);
}
void op59() {};													// nop
void op60() {forth.p.look();}									// look
void op100(void) {												// io_open
	FILE *fileptr;			// pointer to the file handle

	if((fileptr=fopen(forth.ReadLine(),(char *)forth.p.pop()))==(FILE *)NULL) {
		forth.Error("Could not open file: %s",forth.ReadLine());
		return;
	}
	forth.p.push((long)fileptr);	// save the file-handle on the stack
}
void op101(void) {fclose((FILE *)forth.p.pop());}				// io_close
void op102(void){
	forth.p.push((long)feof((FILE *)forth.p.pop()));			// io_eof
}
void op103(void) {												// io_getc
	forth.p.push((long)fgetc((FILE *)forth.p.pop()));
}
void op104(void) {												// io_putc
	forth.p.push((long)fputc((char)forth.p.pop(),(FILE *)forth.p.pop()));
}
void op105(void) {												// io_flush
	forth.p.push((long)fflush((FILE *)forth.p.pop()));
}
void op106(void) {												// io_read
	forth.p.push((long)fread
	((void *)forth.p.pop(),(int)forth.p.pop(),(int)forth.p.pop(),(FILE *)forth.p.pop()));
}
void op107(void) {												// io_write
	forth.p.push((long)fwrite
	((void *)forth.p.pop(),(int)forth.p.pop(),(int)forth.p.pop(),(FILE *)forth.p.pop()));
}
void op108(void) {												// io_seek
	forth.p.push((long)fseek((FILE *)forth.p.pop(),forth.p.pop(),(long)forth.p.pop()));
}
void op109(void) {												// io_tell
	forth.p.push(ftell((FILE *)forth.p.pop()));
}
void op110(void) {forth.p.push((long)stdin);}					// stdin@
void op111(void) {forth.p.push((long)stdout);}					// stdout@

void op150(void) {
forth.p.push((long)atoi((char *)forth.p.pop()));				// atoi
}
void op151(void) {forth.p.push((long)rand());}					// rand
void op152(void) {												// srand
	srand((unsigned int)forth.p.pop());
}
void op153(void) {gotoxy(forth.p.pop(),forth.p.pop());}			// gotoxy
void op154(void) {												// window
	window(forth.p.pop(),forth.p.pop(),forth.p.pop(),forth.p.pop());
}
void op155(void) {forth.p.push(wherex());}						// wherex
void op156(void) {forth.p.push(wherey());}						// wherey
void op157(void) {clrscr();}									// clr
void op200(void) {forth.p.f2i();}								// f2i
void op201(void) {forth.p.i2f();}								// i2f
void op202(void) {forth.p.fpush(forth.p.fpop()+forth.p.fpop());}// f+
void op203(void) {forth.p.fpush(forth.p.fpop()-forth.p.fpop());}// f-
void op204(void) {forth.p.fpush(forth.p.fpop()*forth.p.fpop());}// f*
void op205(void) {forth.p.fpush(forth.p.fpop()/forth.p.fpop());}// f+
void op206(void) {forth.p.fpush(abs(forth.p.fpop()));}			// fabs
void op207(void) {forth.p.fpush(exp(forth.p.fpop()));}			// fexp
void op208(void) {forth.p.fpush(log(forth.p.fpop()));}			// flog
void op209(void) {forth.p.fpush(sin(forth.p.fpop()));}			// fsin
void op210(void) {forth.p.fpush(cos(forth.p.fpop()));}			// fcos
void op211(void) {forth.p.fpush(tan(forth.p.fpop()));}			// ftan
void op212(void) {forth.p.fpush(asin(forth.p.fpop()));}			// fasin
void op213(void) {forth.p.fpush(acos(forth.p.fpop()));}			// facos
void op214(void) {forth.p.fpush(atan(forth.p.fpop()));}			// fatan
void op215(void) {												// f.
	float x=forth.p.fpop();
	if (forth.p.error()) return;
	if(!forth.ReadError()) printf("%g",x) ;
}
void op216(void) {forth.p.fpush(atof(forth.ReadLine()));}		// f ..
void op217(void) {												// finput"
	char buffer[20];			// buffer to hold the input

	op54();						// Print out the quote

	gets(buffer);
	forth.p.fpush(atof(buffer));
}
void op300(void) {												// buildnet
	ann.BuildNet(forth.p.pop(),forth.p.pop(),forth.p.pop()); }
void op301(void) {												// freenet
	ann.FreeNet();}
void op302(void) {                  							// loadnet
	ann.LoadNet(forth.ReadLine());}
void op303(void) {												// savenet
	ann.SaveNet(forth.ReadLine());}
void op304(void) {												// loadweights
	ann.LoadWeights(forth.ReadLine());}
void op305(void) {                               				// saveweights
	ann.SaveWeights(forth.ReadLine());}
void op306(void)	{											// loadtrains
	ann.LoadTrains(forth.ReadLine());}
void op307(void) {												// loadtests
	ann.LoadTests(forth.ReadLine());}
void op308(void) {												// connectnode
	ann.ConnectNode(forth.p.pop(),forth.p.pop());}
void op309(void) {                                  			// conectlayer
	ann.ConnectLayer(forth.p.pop(),forth.p.pop(),
					forth.p.pop(),forth.p.pop()); }
void op310(void) { 												// train
	ann.Train(forth.p.pop()); }
void op311(void) {ann.Test(); }									// test
void op312(void) {ann.SetWeightRange(forth.p.fpop()); }			// !weightrange
void op313(void) {ann.SetSigPriOffset(forth.p.fpop()); }		// !SigPriOffset
void op314(void) {ann.SetEpsilon(forth.p.fpop()); }				// !epsilon
void op315(void) {ann.SetMaxFactor(forth.p.fpop());}			// !maxfactor
void op316(void) {ann.SetDecay(forth.p.fpop());}				// !decay
void op317(void) {ann.SetSplitEpsilon(forth.p.fpop()); }		// !splitepsilon
void op318(void) {forth.p.fpush(ann.ReadTotalError()); }		// @totalerror
void op319(void) {forth.p.push(ann.ReadDidGradient());  }		// @didgradient
void op320(void) {forth.p.push(ann.ReadTotalErrorBits()); }		// @totalerrorbits
void op321(void) {forth.p.fpush(ann.ReadErrOf(forth.p.pop())); }// @error
void op322(void) {												// @output
	forth.p.fpush(ann.ReadOutputOf(forth.p.pop()));
}
void op323(void) {												// @errorsum
	forth.p.fpush(ann.ReadErrSumOf(forth.p.pop()));
}
void op324(void) {												// @numconns
	forth.p.push(ann.ReadNConnsOf(forth.p.pop()));
}
void op325(void) {ann.Forward((float *)forth.p.pop());}			// forward
void op326(void) {ann.Backward((float *)forth.p.pop());}		// backward
void op327(void) {forth.p.fpush(								// @weight
	ann.ReadWeightBetween(forth.p.pop(),forth.p.pop()));}
void op328(void) {ann.SetWeightBetween(                   		// !weight
	forth.p.pop(),forth.p.pop(),forth.p.fpop());}
void op329(void) {forth.p.push(ann.NumUnits());}				// @units
void op330(void) {forth.p.push(ann.NumInput());}				// @inputs
void op331(void) {forth.p.push(ann.NumHidden());}				// @hidden
void op332(void) {forth.p.push(ann.NumOutput());}				// @outputs

