;;; **********************************************************************
;;; Copyright (c) 89-93, 94 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; address email to: hkt@zkm.de
;;; **********************************************************************

#+(or cltl2 lispworks clisp)
(progn
  (defpackage :stella 
    (:use :COMMON-MUSIC
          :TL
          #-(and clisp pcl) :COMMON-LISP #+(and clisp pcl) :LISP
          #+(or pcl mcl lispworks clisp) :WALKER
          #+pcl :PCL
          #+(or (and excl cltl2) lispworks) :CLOS
          #+clm :CLM
    )
    #+(and clisp pcl) (:import-from "PCL" "PRINTING-RANDOM-THING")
    #+(and clisp (not pcl))
    (:import-from "COMMON-MUSIC"
      #+dos "USER-HOMEDIR-PATHNAME"
      "ALLOCATE-INSTANCE" "CLASS-SLOTS"  
      "CLASS-PRECEDENCE-LIST" "CLASS-DIRECT-SUPERCLASSES"
      "SLOT-DEFINITION-NAME" "SLOT-DEFINITION-INITARGS"
      "SLOT-DEFINITION-INITFORM"
      "SLOT-DEFINITION-READERS" "SLOT-DEFINITION-WRITERS" 
      "SLOT-VALUE-USING-CLASS" "SLOT-BOUNDP-USING-CLASS" 
      "SLOT-MAKUNBOUND-USING-CLASS" "CHANGE-CLASS" "CLASS-PROTOTYPE")
    )
  (in-package :stella))

#-(or cltl2 lispworks clisp)
(in-package ':stella 
             :use (list (find-package ':lisp)
                        (find-package ':walker)
                  #+pcl (find-package ':pcl)
                        (find-package ':tl)
                  #+clm (find-package ':clm)
                        (find-package ':common-music)))

(shadow '(merge in-syntax *syntax* listen cm:part cm:find-part cm:status?
          #+aclpc fill
          #+(and excl sgi) position
         ) 
       :stella)

#+(and excl cltl2)
(import '(clos::walk-form clos::variable-lexical-p clos::variable-special-p
	  clos::variable-globally-special-p))

#+cmn
(import '(cmn::size cmn::metronome))

#+pcl
(eval-when (compile load eval)
  #-clisp (import '(pcl::printing-random-thing))
  (cond ((string= pcl::*pcl-system-date* "March 92 PCL (2c)")
         (import '(pcl::class-prototype
                   pcl::class-slots
                   pcl::allocate-instance
                   pcl::standard-class 
                   pcl::validate-superclass
                   pcl::class-precedence-list	    
                   pcl::class-direct-superclasses
                   pcl::class-direct-subclasses 
                   pcl::class-direct-slots
                   pcl::finalize-inheritance	    
                   pcl::class-finalized-p	    
                   pcl::class-direct-slots	    
                   pcl::slot-value-using-class 
                   pcl::slot-boundp-using-class
                   pcl::slot-makunbound-using-class
                   pcl::slot-definition-name	    
                   pcl::slot-definition-readers	    
                   pcl::slot-definition-writers
                   pcl::slot-definition-initargs
                   pcl::slot-definition-initform
                   pcl::slot-definition-initfunction
                   pcl::slot-definition-allocation
                   pcl::slot-definition-type )))
        ((string= pcl::*pcl-system-date* "September 16 92 PCL (f)")
         nil)
        (t
         (error "~&Common Music has only been tested in March 92 PCL (2c).  It may work in your version of PCL, but then again it may not.  The easiest thing to do is to ftp March 92 PCL from guido.zkm.de and install.  Otherwise, edit the files: common-music.lisp and stella/pkg.lisp to get rid of this error message code, and then figure out the import statements that you need for your version of pcl.")))
)

#+mcl
(progn
  (import '(ccl:class-direct-superclasses ccl:class-direct-subclasses 
            ccl:class-prototype ccl:class-precedence-list
            ccl:slot-definition-name))
  (defun class-slots (class) (ccl:class-instance-slots class))
  (defun class-direct-slots (class) (ccl:class-direct-instance-slots class))
  (defun slot-definition-initargs (slot) (third slot))
  (defun slot-definition-initform (slot) 
    (and (second slot) 
         (if (functionp (second slot))
             (funcall (second slot))
           (if (consp (second slot))
               (car (second slot))
            nil))))
  (defun slot-definition-readers (slot)
    (declare (ignore slot))
    (error "slot-definition-readers undefined in mcl"))
  (defun slot-definition-writers (slot) 
    (declare (ignore slot))
    (error "slot-definition-writers undefined in mcl"))
  (defmacro slot-value-using-class (class instance slot)
    (declare (ignore class))
    `(slot-value ,instance (ccl:slot-definition-name ,slot)))
  (defmacro slot-boundp-using-class (class instance slot)
    (declare (ignore class))
    `(slot-boundp ,instance (ccl:slot-definition-name ,slot)))
  (defmacro slot-makunbound-using-class (class instance slot)
    (declare (ignore class))
    `(slot-makunbound ,instance (ccl:slot-definition-name ,slot)))
)

(export '(stella))

