;;; **********************************************************************
;;; Copyright (c) 89, 90, 91, 92, 93 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; send to: hkt@zkm.de
;;; **********************************************************************

(in-package :stella)

;;;
;;; music kit listening. must be compiled after mk.lisp has been loaded.
;;; to get this working, to the following:
;;; 1) get and install Chris Chafe's MKLisp.app.
;;; 2) fix the defvar below to point to the MKLisp app you installed.
;;; 3) search for "mkl" in build.lisp and uncomment out that line.
;;; 4) build common music 
;;; 5) then boot up

(defvar mklisp.app "/dist/220/Apps/MKLisp.app")

(eval-when (load eval)
 (progn (load (concatenate 'string mklisp.app "/" "MKLispUser.o"))
        (load (concatenate 'string mklisp.app "/" "ConnectToServer.o")))
)

(ff:defforeign 'mklisp_setup :arguments '() ; :arg-checking nil  :prototype t
              :return-type :integer)
(ff:defforeign 'mklisp_tzero :arguments '(integer)
               ; :arg-checking nil  :prototype t
               :return-type :integer)
(ff:defforeign 'mklisp_reorchestrate_rtn  :arguments '(integer)
               ; :arg-checking nil  :prototype t
               :return-type :integer)
(ff:defforeign 'mklisp_paramid_rtn  :arguments '(integer string)
               ; :arg-checking nil  :prototype t
  	      :return-type :integer)
(ff:defforeign 'mklisp_makeevent 
               :arguments '(integer integer integer float integer)
               ; :arg-checking nil  :prototype t
               :return-type :integer)
(ff:defforeign 'mklisp_sendevent  :arguments '(integer float)
               ; :arg-checking nil  :prototype t
               :return-type :integer)
(ff:defforeign 'mklisp_addfloatparam  :arguments '(integer integer float)
               ; :arg-checking nil  :prototype t
               :return-type :integer)
(ff:defforeign 'mklisp_addstringparam  :arguments '(integer integer string)
              ;  :arg-checking nil  :prototype t
               :return-type :integer)
(ff:defforeign 'mklisp_addintparam  :arguments '(integer integer integer)
              ;  :arg-checking nil  :prototype t
               :return-type :integer)

#|
(defun setup  () (setf *port-num* (mklisp_setup)))
(defun tzero  () (mklisp_tzero *port-num*))
(defun reorchestrate  () (mklisp_reorchestrate_rtn *port-num*))
(defun paramid  (str) (mklisp_paramid_rtn *port-num* str))
(defun makeevent  (integer1 integer2 flt integer3) ; not used -- see below
  (mklisp_makeevent *port-num* integer1 integer2 flt integer3))
(defun sendevent  (flt)
  (mklisp_sendevent *port-num* flt))
(defun addfloatparam  (int flt)
  (mklisp_addfloatparam *port-num* int flt))
(defun addstringparam  (int str)
  (mklisp_addstringparam *port-num* int str))
(defun addintparam  (int1 int2)
  (mklisp_addintparam *port-num* int1 int2))
(defun make-event (notetype notetag dur patch)
  (mklisp_makeevent *port-num*
		    (ecase notetype
			   (:noteon 258)
			   (:noteupdate 260)
			   (:noteoff 259)
			   (:notedur 257))
		    notetag 			; notetag in the synthinstrument
		    (float dur)
		    patch))
|#

(defvar *port-num* nil)

(defclass music-kit-listener (event-stream)
  ((syntax :initform (find-syntax ':music-kit))))

(defmethod event-stream-matches-p ((object music-kit-listener) args)
  (declare (ignore args))
  ;; currently only one music-kit-listener at a time.
  object)

(defmethod open-listener ((syntax music-kit) &rest args)
  (if (slot-boundp syntax 'listener)
      (apply #'open-event-stream (slot-value syntax 'listener) args)
    (let ((stream (apply #'open-event-stream (find-class 'music-kit-listener)
                         args)))
      (when stream
        (setf (slot-value syntax 'listener) stream))
      stream)))

(defmethod close-listener ((syntax music-kit) &optional mode)
  (when (slot-boundp syntax 'listener)
    (case mode
      (:error (mklisp_sendevent *port-num* 0.0))
      (:force ))))

(defmethod open-event-stream ((stream music-kit-listener) &rest args)
  (declare (ignore args))
  (unless *port-num*
    (excl:shell (format nil "open ~A" mklisp.app))
    (sleep 10)
    (setf *port-num* (mklisp_setup))
    (setf (slot-value stream 'stream) *port-num*)
    (mklisp_reorchestrate_rtn *port-num*)
    (mklisp_reorchestrate_rtn *port-num*)
    (mklisp_reorchestrate_rtn *port-num*))
   stream)

(defparameter *part-counter* -1)

(defmethod initialize-stream-for-processing ((stream music-kit-listener))
  (setf *part-counter* -1)
  (when (= 1 (mklisp_reorchestrate_rtn *port-num*))
	(mklisp_reorchestrate_rtn *port-num*)) ; user aborted a play, so resync
  (mklisp_reorchestrate_rtn *port-num*) ; maybe?
  (mklisp_tzero *port-num*)
  t)

(defmethod deinitialize-stream-for-processing ((stream music-kit-listener))
  (with-open-file (file "~/.mkcm.score"
                   :direction ':output :if-exists ':supersede)
    (map nil #'(lambda (p)
                 (when (slot-value p 'include)
                   (print-part p file)
                   (setf (slot-value p 'include) nil)))
         *parts*))
  t)


;;;
;;;
;;;

(eval-when (compile load eval)

(defun mk-make-sender (slot)
  (let ((e (assoc slot *mk-parameter-info*)))
    (unless e (error "No parameter entry for ~S." slot))
    `(lambda (val) (,(fourth e) *port-num* , (third e) val))))
)


(defmethod write-event ((object music-kit-note)
                        (stream music-kit-listener))
  (let ((part (if (slot-boundp object 'part) (slot-value object 'part)
                (find-part (class-name (class-of object)))))
        (notetype (slot-value-or-default object 'type ':duration))
         )
    (unless (part-include part)
      (setf (part-include part)  (incf *part-counter*)))
    (mklisp_makeevent *port-num* 
                      (ecase notetype
                       (:noteon 258) 
                       (:noteupdate 260) 
                       (:noteoff 259) 
                       (:duration 257))  ; duration=notedur
                      0 			 ; notetag in the synthinstrument
                      (float (if (slot-boundp object 'duration)
                                 (slot-value object 'duration)
                               (slot-value object 'rhythm)))
                      (part-include part))
    (mk-send-parameters object)
    (mklisp_sendevent *port-num* (float (slot-value object 'time)))))

;;;
;;;
;;;

#|

(defmethod mk-send-parameters ((obj DBFm1vi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
     freq keyNum pitchBend pitchBendSensitivity bearing amp velocity 
     velocitySensitivity controlChange controlVal ampEnv amp0 amp1 ampatt
     amprel freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen
     phase waveform0 waveform1 balancesensitivity cratio m1ratio m1ind
     m1indenv m1ind0 m1ind1 m1indatt m1indrel m1waveform m1phase bright 
     aftertouch aftertouchsensitivity svibfreq svibamp svibfreq0 svibfreq1
     svibamp0 svibamp1 rvibamp))

(defmethod mk-send-parameters ((obj DBWave1vi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt
    amprel freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen 
    phase svibfreq svibamp svibfreq0 svibfreq1 svibamp0 svibamp1 rvibamp
    balancesensitivity waveform0 waveform1))

(defmethod mk-send-parameters ((obj dbwave2vi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    svibfreq svibamp svibfreq0 svibfreq1 svibamp0 svibamp1 rvibamp 
    pansensitivity waveform0 waveform1 waveformatt waveformrel waveformenv))

(defmethod mk-send-parameters ((obj fm1i))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    cratio m1ratio m1ind m1indenv m1ind0 m1ind1 m1indatt m1indrel m1waveform 
    m1phase bright aftertouch aftertouchsensitivity))

(defmethod mk-send-parameters ((obj fm1vi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    cratio m1ratio m1ind m1indenv m1ind0 m1ind1 m1indatt m1indrel m1waveform 
    m1phase bright aftertouch aftertouchsensitivity svibfreq svibamp svibfreq0 
    svibfreq1 svibamp0 svibamp1 rvibamp))

(defmethod mk-send-parameters ((obj fm2cnvi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    noiseamp noiseampenv noiseamp0 noiseamp1 noiseampatt noiseamprel 
    breathsensitivity pansensitivity cratio m1ratio m1ind m1indenv m1ind0 
    m1ind1 m1indatt m1indrel m1waveform m1phase bright aftertouch 
    aftertouchsensitivity m2ratio m2ind m2indenv m2ind0 m2ind1 m2indatt 
    m2indrel m2waveform m2phase svibfreq svibamp svibfreq0 svibfreq1 svibamp0 
    svibamp1 rvibamp))

(defmethod mk-send-parameters ((obj fm2cvi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    cratio m1ratio m1ind m1indenv m1ind0 m1ind1 m1indatt m1indrel m1waveform 
    m1phase bright aftertouch aftertouchsensitivity m2ratio m2ind m2indenv 
    m2ind0 m2ind1 m2indatt m2indrel m2waveform m2phase svibfreq svibamp 
    svibfreq0 svibfreq1 svibamp0 svibamp1 rvibamp))


(defmethod mk-send-parameters ((obj fm2pnvi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    noiseamp noiseampenv noiseamp0 noiseamp1 noiseampatt noiseamprel 
    breathsensitivity pansensitivity balancesensitivity cratio m1ratio m1ind 
    m1indenv m1ind0 m1ind1 m1indatt m1indrel m1waveform m1phase bright 
    aftertouch aftertouchsensitivity m2ratio m2ind m2indenv m2ind0 m2ind1 
    m2indatt m2indrel m2waveform m2phase svibfreq svibamp svibfreq0 svibfreq1 
    svibamp0 svibamp1 rvibamp))

(defmethod mk-send-parameters ((obj fm2pvi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    pansensitivity balancesensitivity cratio m1ratio m1ind m1indenv m1ind0 
    m1ind1 m1indatt m1indrel m1waveform m1phase bright aftertouch 
    aftertouchsensitivity m2ratio m2ind m2indenv m2ind0 m2ind1 m2indatt 
    m2indrel m2waveform m2phase svibfreq svibamp svibfreq0 svibfreq1 svibamp0 
    svibamp1 rvibamp))

(defmethod mk-send-parameters ((obj mkmidi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    keypressure aftertouch controlchange pitchbend programchange timecodeq 
    songposition songselect tunerequest sysexclusive chanmode sysrealtime
    basicchan controlval monochans velocity relvelocity keynum freq))

(defmethod mk-send-parameters ((obj mixsounds))
  (error "no listening method for mixsounds"))


(defmethod mk-send-parameters ((obj pluck))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval lowestfreq sustain picknoise
    decay bright amprel))


(defmethod mk-send-parameters ((obj wave1i))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase))


(defmethod mk-send-parameters ((obj wave1vi))
  (declare (optimize (speed 3) (safety 0)))
  (formatting-slots (obj nil :print-if :bound :printer nil :delimiter nil
                             :constructor mk-make-sender)
    freq keynum pitchbend pitchbendsensitivity bearing amp velocity 
    velocitysensitivity controlchange controlval ampenv amp0 amp1 ampatt amprel 
    freqenv freq0 freq1 freqatt freqrel portamento waveform wavelen phase 
    svibfreq svibamp svibfreq0 svibfreq1 svibamp0 svibamp1 rvibamp))


|#

