#ifndef	_mklisp_MKLisp
#define	_mklisp_MKLisp

/* Module MKLisp */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#ifndef	mig_external
#define mig_external extern
#endif

#include <mach/std_types.h>
/*  contain's mig interface declarations
turned off type checking because Lisp does it already
 */

#ifndef _MKLisp_TYPES_
#define _MKLisp_TYPES_

typedef char my_string[8*50];
typedef double dbl;

#endif _MKLisp_TYPES_

#define	TypeCheck 0


/* Routine mklisp_reorchestrate */
mig_external kern_return_t mklisp_reorchestrate (
	port_t server,
	int *playing);

/* Routine mklisp_tzero */
mig_external kern_return_t mklisp_tzero (
	port_t server);

/* Routine mklisp_paramid */
mig_external kern_return_t mklisp_paramid (
	port_t server,
	my_string name,
	int *idnum);

/* SimpleRoutine mklisp_makeevent */
mig_external kern_return_t mklisp_makeevent (
	port_t server,
	int notetype,
	int notetag,
	dbl dur,
	int patch);

/* SimpleRoutine mklisp_sendevent */
mig_external kern_return_t mklisp_sendevent (
	port_t server,
	dbl delay);

/* SimpleRoutine mklisp_addfloatparam */
mig_external kern_return_t mklisp_addfloatparam (
	port_t server,
	int paramid,
	dbl floatVal);

/* SimpleRoutine mklisp_addstringparam */
mig_external kern_return_t mklisp_addstringparam (
	port_t server,
	int paramid,
	my_string stringVal);

/* SimpleRoutine mklisp_addintparam */
mig_external kern_return_t mklisp_addintparam (
	port_t server,
	int paramid,
	int intVal);

#endif	_mklisp_MKLisp

#include <mach/mach_types.h>
#include <mach/message.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#if	!defined(KERNEL) && !defined(MIG_NO_STRINGS)
#include <strings.h>
#endif
/* LINTLIBRARY */

extern port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msg_request_port	msg_remote_port
#define msg_reply_port		msg_local_port


/* Routine reorchestrate */
mig_external kern_return_t mklisp_reorchestrate (
	port_t server,
	int *playing)
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t playingType;
		int playing;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 24;

#if	UseStaticMsgType
	static const msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t playingCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 0;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 100)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msg_size != 40) || (msg_simple != TRUE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->playingType != * (int *) &playingCheck)
#else	UseStaticMsgType
	if ((OutP->playingType.msg_type_inline != TRUE) ||
	    (OutP->playingType.msg_type_longform != FALSE) ||
	    (OutP->playingType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->playingType.msg_type_number != 1) ||
	    (OutP->playingType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*playing /* playing */ = /* *playing */ OutP->playing;

	return OutP->RetCode;
}

/* Routine tzero */
mig_external kern_return_t mklisp_tzero (
	port_t server)
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 24;

#if	UseStaticMsgType
	static const msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 1;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 101)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msg_size != 32) || (msg_simple != TRUE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

	return OutP->RetCode;
}

/* Routine paramid */
mig_external kern_return_t mklisp_paramid (
	port_t server,
	my_string name,
	int *idnum)
{
	typedef struct {
		msg_header_t Head;
		msg_type_long_t nameType;
		my_string name;
		char namePad[2];
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t idnumType;
		int idnum;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size = 88;

#if	UseStaticMsgType
	static const msg_type_long_t nameType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
	},
		/* msg_type_long_name = */	MSG_TYPE_STRING,
		/* msg_type_long_size = */	400,
		/* msg_type_long_number = */	1,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t RetCodeCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t idnumCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->nameType = nameType;
#else	UseStaticMsgType
	InP->nameType.msg_type_long_name = MSG_TYPE_STRING;
	InP->nameType.msg_type_long_size = 400;
	InP->nameType.msg_type_long_number = 1;
	InP->nameType.msg_type_header.msg_type_inline = TRUE;
	InP->nameType.msg_type_header.msg_type_longform = TRUE;
	InP->nameType.msg_type_header.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	(void) strncpy(InP->name /* name */, /* name */ name, 50);
	InP->name /* name */[49] = '\0';

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = mig_get_reply_port();
	InP->Head.msg_id = 2;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		return msg_result;
	}

#if	TypeCheck
	msg_size = OutP->Head.msg_size;
	msg_simple = OutP->Head.msg_simple;
#endif	TypeCheck

	if (OutP->Head.msg_id != 102)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if (((msg_size != 40) || (msg_simple != TRUE)) &&
	    ((msg_size != sizeof(death_pill_t)) ||
	     (msg_simple != TRUE) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msg_type_inline != TRUE) ||
	    (OutP->RetCodeType.msg_type_longform != FALSE) ||
	    (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msg_type_number != 1) ||
	    (OutP->RetCodeType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->idnumType != * (int *) &idnumCheck)
#else	UseStaticMsgType
	if ((OutP->idnumType.msg_type_inline != TRUE) ||
	    (OutP->idnumType.msg_type_longform != FALSE) ||
	    (OutP->idnumType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (OutP->idnumType.msg_type_number != 1) ||
	    (OutP->idnumType.msg_type_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*idnum /* idnum */ = /* *idnum */ OutP->idnum;

	return OutP->RetCode;
}

/* SimpleRoutine makeevent */
mig_external kern_return_t mklisp_makeevent (
	port_t server,
	int notetype,
	int notetag,
	dbl dur,
	int patch)
{
	typedef struct {
		msg_header_t Head;
		msg_type_t notetypeType;
		int notetype;
		msg_type_t notetagType;
		int notetag;
		msg_type_t durType;
		dbl dur;
		msg_type_t patchType;
		int patch;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	unsigned int msg_size = 60;

#if	UseStaticMsgType
	static const msg_type_t notetypeType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t notetagType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t durType = {
		/* msg_type_name = */		MSG_TYPE_REAL,
		/* msg_type_size = */		64,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t patchType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->notetypeType = notetypeType;
#else	UseStaticMsgType
	InP->notetypeType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->notetypeType.msg_type_size = 32;
	InP->notetypeType.msg_type_number = 1;
	InP->notetypeType.msg_type_inline = TRUE;
	InP->notetypeType.msg_type_longform = FALSE;
	InP->notetypeType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->notetype /* notetype */ = /* notetype */ notetype;

#if	UseStaticMsgType
	InP->notetagType = notetagType;
#else	UseStaticMsgType
	InP->notetagType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->notetagType.msg_type_size = 32;
	InP->notetagType.msg_type_number = 1;
	InP->notetagType.msg_type_inline = TRUE;
	InP->notetagType.msg_type_longform = FALSE;
	InP->notetagType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->notetag /* notetag */ = /* notetag */ notetag;

#if	UseStaticMsgType
	InP->durType = durType;
#else	UseStaticMsgType
	InP->durType.msg_type_name = MSG_TYPE_REAL;
	InP->durType.msg_type_size = 64;
	InP->durType.msg_type_number = 1;
	InP->durType.msg_type_inline = TRUE;
	InP->durType.msg_type_longform = FALSE;
	InP->durType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->dur /* dur */ = /* dur */ dur;

#if	UseStaticMsgType
	InP->patchType = patchType;
#else	UseStaticMsgType
	InP->patchType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->patchType.msg_type_size = 32;
	InP->patchType.msg_type_number = 1;
	InP->patchType.msg_type_inline = TRUE;
	InP->patchType.msg_type_longform = FALSE;
	InP->patchType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->patch /* patch */ = /* patch */ patch;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = PORT_NULL;
	InP->Head.msg_id = 3;

	return msg_send(&InP->Head, MSG_OPTION_NONE, 0);
}

/* SimpleRoutine sendevent */
mig_external kern_return_t mklisp_sendevent (
	port_t server,
	dbl delay)
{
	typedef struct {
		msg_header_t Head;
		msg_type_t delayType;
		dbl delay;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	unsigned int msg_size = 36;

#if	UseStaticMsgType
	static const msg_type_t delayType = {
		/* msg_type_name = */		MSG_TYPE_REAL,
		/* msg_type_size = */		64,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->delayType = delayType;
#else	UseStaticMsgType
	InP->delayType.msg_type_name = MSG_TYPE_REAL;
	InP->delayType.msg_type_size = 64;
	InP->delayType.msg_type_number = 1;
	InP->delayType.msg_type_inline = TRUE;
	InP->delayType.msg_type_longform = FALSE;
	InP->delayType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->delay /* delay */ = /* delay */ delay;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = PORT_NULL;
	InP->Head.msg_id = 4;

	return msg_send(&InP->Head, MSG_OPTION_NONE, 0);
}

/* SimpleRoutine addfloatparam */
mig_external kern_return_t mklisp_addfloatparam (
	port_t server,
	int paramid,
	dbl floatVal)
{
	typedef struct {
		msg_header_t Head;
		msg_type_t paramidType;
		int paramid;
		msg_type_t floatValType;
		dbl floatVal;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	unsigned int msg_size = 44;

#if	UseStaticMsgType
	static const msg_type_t paramidType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t floatValType = {
		/* msg_type_name = */		MSG_TYPE_REAL,
		/* msg_type_size = */		64,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->paramidType = paramidType;
#else	UseStaticMsgType
	InP->paramidType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->paramidType.msg_type_size = 32;
	InP->paramidType.msg_type_number = 1;
	InP->paramidType.msg_type_inline = TRUE;
	InP->paramidType.msg_type_longform = FALSE;
	InP->paramidType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->paramid /* paramid */ = /* paramid */ paramid;

#if	UseStaticMsgType
	InP->floatValType = floatValType;
#else	UseStaticMsgType
	InP->floatValType.msg_type_name = MSG_TYPE_REAL;
	InP->floatValType.msg_type_size = 64;
	InP->floatValType.msg_type_number = 1;
	InP->floatValType.msg_type_inline = TRUE;
	InP->floatValType.msg_type_longform = FALSE;
	InP->floatValType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->floatVal /* floatVal */ = /* floatVal */ floatVal;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = PORT_NULL;
	InP->Head.msg_id = 5;

	return msg_send(&InP->Head, MSG_OPTION_NONE, 0);
}

/* SimpleRoutine addstringparam */
mig_external kern_return_t mklisp_addstringparam (
	port_t server,
	int paramid,
	my_string stringVal)
{
	typedef struct {
		msg_header_t Head;
		msg_type_t paramidType;
		int paramid;
		msg_type_long_t stringValType;
		my_string stringVal;
		char stringValPad[2];
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	unsigned int msg_size = 96;

#if	UseStaticMsgType
	static const msg_type_t paramidType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_long_t stringValType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
	},
		/* msg_type_long_name = */	MSG_TYPE_STRING,
		/* msg_type_long_size = */	400,
		/* msg_type_long_number = */	1,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->paramidType = paramidType;
#else	UseStaticMsgType
	InP->paramidType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->paramidType.msg_type_size = 32;
	InP->paramidType.msg_type_number = 1;
	InP->paramidType.msg_type_inline = TRUE;
	InP->paramidType.msg_type_longform = FALSE;
	InP->paramidType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->paramid /* paramid */ = /* paramid */ paramid;

#if	UseStaticMsgType
	InP->stringValType = stringValType;
#else	UseStaticMsgType
	InP->stringValType.msg_type_long_name = MSG_TYPE_STRING;
	InP->stringValType.msg_type_long_size = 400;
	InP->stringValType.msg_type_long_number = 1;
	InP->stringValType.msg_type_header.msg_type_inline = TRUE;
	InP->stringValType.msg_type_header.msg_type_longform = TRUE;
	InP->stringValType.msg_type_header.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	(void) strncpy(InP->stringVal /* stringVal */, /* stringVal */ stringVal, 50);
	InP->stringVal /* stringVal */[49] = '\0';

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = PORT_NULL;
	InP->Head.msg_id = 6;

	return msg_send(&InP->Head, MSG_OPTION_NONE, 0);
}

/* SimpleRoutine addintparam */
mig_external kern_return_t mklisp_addintparam (
	port_t server,
	int paramid,
	int intVal)
{
	typedef struct {
		msg_header_t Head;
		msg_type_t paramidType;
		int paramid;
		msg_type_t intValType;
		int intVal;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	unsigned int msg_size = 40;

#if	UseStaticMsgType
	static const msg_type_t paramidType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static const msg_type_t intValType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */		0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->paramidType = paramidType;
#else	UseStaticMsgType
	InP->paramidType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->paramidType.msg_type_size = 32;
	InP->paramidType.msg_type_number = 1;
	InP->paramidType.msg_type_inline = TRUE;
	InP->paramidType.msg_type_longform = FALSE;
	InP->paramidType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->paramid /* paramid */ = /* paramid */ paramid;

#if	UseStaticMsgType
	InP->intValType = intValType;
#else	UseStaticMsgType
	InP->intValType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->intValType.msg_type_size = 32;
	InP->intValType.msg_type_number = 1;
	InP->intValType.msg_type_inline = TRUE;
	InP->intValType.msg_type_longform = FALSE;
	InP->intValType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->intVal /* intVal */ = /* intVal */ intVal;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = msg_size;
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_request_port = server;
	InP->Head.msg_reply_port = PORT_NULL;
	InP->Head.msg_id = 7;

	return msg_send(&InP->Head, MSG_OPTION_NONE, 0);
}
/* add.c:  Client program for add example */

#import <mach/mach.h>
#import <stdio.h>

int mklisp_setup()
{
	kern_return_t 	ret;
	port_t		server;
	 
	
	/* Find the server. */
	ret = netname_look_up(name_server_port, "", "MKLisp", &server);
	
	if (ret != KERN_SUCCESS)
	{
		/* Print the network name server's error message. */
		mach_error("Lookup of MKLisp server failed", ret);	
		return 0;
	}
	if (server == PORT_NULL)
	{
		fprintf(stderr, "Couldn't find the MKLisp server.\n");
		return 0;
	}
	
	return (int)server;
}
int mklisp_reorchestrate_rtn(server)
port_t server;
{	
	kern_return_t 	ret;
	int val;
        ret = mklisp_reorchestrate(server, &val);
	if (ret != KERN_SUCCESS) mach_error("mklisp_reorchestrate failed", ret);	
	return val;
}
int mklisp_paramid_rtn(server, str)
port_t server;
char *str;
{	
	kern_return_t 	ret;
	int val;
        ret = mklisp_paramid(server, str, &val);
	if (ret != KERN_SUCCESS) mach_error("mklisp_paramid failed", ret);	
	return val;
}