(in-package :stella)

#|
Implementing Markov processes in graph item streams.

To generate 1st order Markov chains use random item steams for each node's
TO field. For example, in the graph:

        (items (a to (items a b c in random))
               (b to (items (b weight .25) c in random))
               (c to a)
               in graph)

each node determines its sucessor node according weighted random selection
corresponding to the transition table:

                       Current:
	             A    B    C
                A  .333  0.0  1.0
        Next:   B  .333  .25  0.0
                C  .333  .75  0.0

In higher order Markov processes, each current node selects its successor
node based on its own id and the node ids of one or more previous choices.  
The PREVIOUS option for the graph pattern sets how many previous choices
a graph "remembers".  The value of PREVIOUS should be a number or a list
of node ids to become the initial previous state of the stream.  To produce
the next node in the graph, PREVIOUS number of selected ids are passed to
the selection function along with the current node.  The current node may
then use this list of past ids as a key for choosing the next TO node, by
using the previous ids as a "lookup value" in a selection table of TO 
nodes. This slection process is automated if you use the IDSEL 
macro to specify the TO links for a node:

IDSEL [(previous+) {to}]+				[Macro]

IDSEL create a selection table from a sequence of previous ids and
TO link descriptions. (previous+) is a list of previous ids and {to}
is the sucessor id or stream of ids to select the next node from when
(previous+) matches the actual nodes that were previously selected.
If only one previous id is needed, (previous+) does not need to be
a list. For example, a node for 2nd order Markov might have the
following selection table as its TO value:

(notes  ...
  (c4 id a to (idsel a (items a b c in random) 
                     b (items (a weight 4) b in random)
	             c a))
  ... in graph)

which corresponds to the transition table portion:

                    Current+Last:
	             A    B    C
	             B    B    B
	        A  .333  0.0  1.0
	Next:   B  .333  .25  0.0
	        C  .333  .75  0.0

IDSEL uses pattern matching to look up the previous id choices in the
selection table.  As a conseqence of this selection tables need not be
fully enumerated and "wildcard" selection is possible.  previous ids are
matched with candidate  {id+} descriptions using the following two rules:

Matching occurs for the length of {id+}, which may be less than PREVIOUS.
If every {id+} matches its correspoding position in PREVIOUS, then that
table entry is selected. This allows multiple entries in a table to be
collapsed to a single selection.

A * at any position in {id+} matches the corresponding previous choice,
no matter what it was.  For example, the following two selection tables are
equivalent:

        (idsel a (items a b c d in random)
               b (items (a weight 4) c d in random)
               c (items a b c d in random)
               d (items a b c d in random))

        (idsel b (items (a weight 4) c d in random)
               * (items a b c d in random))

Example:

The Stephen Foster example (2nd order Markov) from Chapter 8 in Dodge/Jerse
coded as an algorithm.

|#

(algorithm stephen-foster midi-note (length 60 amplitude .5)
  (setf note
    (item
      (notes
        (d4 to (idsel b3 d4
                      cs4 (items (d4 weight .3125) (e4 weight .3125)
                                 (a4 weight .3125) in random)
                      d4 (items (cs4 weight .125) (d4 weight .125)
                                (e4 weight .5625) (fs4 weight .125) 
                                (a4 weight .0625) in random)
                      e4 (items (b3 weight .0625) (d4 weight .0625) 
                                (e4 weight .25) (fs4 weight .3125)
                                (a4 weight .0625) (cs5 weight .0625)
                                (d5 weight .1875) in random)
                      fs4 (items (e4 weight .75) (fs4 weight .1875)
                                 (g4 weight .0625) in random)
                      a4 (items (e4 weight .6875) (fs4 weight .3125) in random)
                      b4 d4))        (b3 to (idsel d4 d4))
        (cs4 to (idsel d4 d4 e4 d4))
        
        (e4 to (idsel d4 (items (d4 weight .1875) (e4 weight .25) 
                                (fs4 weight .5) (a4 weight .0625) in random)
                      e4 (items (cs4 weight .0625) (d4 weight .75) 
                                (e4 weight .0625) (fs4 weight .125) in random)
                      fs4 (items (cs4 weight .125) (d4 weight .4375) 
                                 (e4 weight .1875) (fs4 weight .125) 
                                 (a4 weight .0625) (d5 weight .0625) 
                                 in random)))
        (fs4 to (idsel d4 (items (e4 weight .4375) (fs4 weight .1875)
                                 (g4 weight .125) (a4 weight .25) in random)
                       e4 (items (d4 weight .0625) (e4 weight .1875)
                                 (fs4 weight .3125) (g4 weight .25)
                                 (a4 weight .0625) (b4 weight .0625) in random)
                       fs4 (items (d4 weight .1875) (e4 weight .25)
                                  (fs4 weight .3125) (g4 weight .125)
                                  (a4 weight .0625) in random)
                       g4 (items (e4 weight .5) (g4 weight .5) in random)
                       a4 (items (d4 weight .3125) (e4 weight .25) 
                                 (fs4 weight .1875) (g4 weight .0625) 
                                 (a4 weight .125) (b4 weight .0625) in random)
                       b4 (items (e4 weight .6875) (fs4 weight .3125)
                                 in random)))
        (g4 to (idsel d4 (items (fs4 weight .6875) (b4 weight .3125)
                                in random)
                      fs4 (items (fs4 weight .25) (g4 weight .1875)
                                 (a4 weight .3125) (b4 weight .1875) in random)
                      g4 (items (g4 weight .5) (a4 weight .5) in random)
                      a4 fs4
                      b4 b4))
        (gs4 to (idsel a4 a4))
        (a4 to (idsel d4 (items (fs4 weight .25) (a4 weight .75) in random)
                      e4 (items (a4 weight .8125) (b4 weight .1875) in random)
                      fs4 (items (fs4 weight .125) (a4 weight .625)
                                 (b4 weight .1875) (d5 weight .0625) in random)
                      g4 (items (d4 weight .125) (a4 weight .625) 
                                (d5 weight .25) in random)
                      gs4 a4
                      a4 (items (fs4 weight .25) (g4 weight .0625)
                                (gs4 weight .0625) (a4 weight .3125) 
                                (b4 weight .3125) in random)
                      b4 (items (d4 weight .0625) (fs4 weight .5625)
                                (g4 weight .0625) (a4 weight .125)
                                (b4 weight .0625) (d5 weight .125) 
                                in random)
                      d5 (items (fs4 weight .875) (a4 weight .125) in random)
                      e5 a4))
        (b4 to (idsel fs4 a4
                      g4 a4
                      a4 (items (d4 weight .0625) (fs4 weight .0625) 
                                (a4 weight .75) (b4 weight .0625) 
                                (b4 weight .0625) in random)
                      b4 (items (fs4 weight .125) (a4 weight .75)
                                (d5 weight .125) in random)
                      cs5 a4
                      d5 (items (g4 weight .0625) (a4 weight .3125)
                                (b4 weight .3125) (d5 weight .25) in random)))
        (cs5 to (idsel d4 d5 
                       d5 (items (b4 weight .75) (d5 weight .25) in random)
                       e5 d5))
        (d5 to (idsel d4 (items (a4 weight .125) (b4 weight .6875)
                                (cs5 weight .1875) in random)
                      e4 cs5
                      a4 (items (a4 weight .3125) (b4 weight .3125)
                                (cs5 weight .1875) (d5 weight .125) in random)
                      b4 (items (a4 weight .5625) (b4 weight .125)
                                (cs5 weight .3125) in random)
                      cs5 (items (b4 weight .3125) (e5 weight .625) in random)
                      d5 b4))
        (e5 to (idsel d5 (items (a4 weight .3125) (cs5 weight .6875) 
                                in random)))
        in graph previous 1)))

  (setf rhythm
        (item (rhythms ((rhythms h h) weight .125)
                       ((rhythms h h) weight .25)
                       ((rhythms q for 4) weight .125)
                       ((rhythms h q q) weight .125)
                       ((rhythms q q h) weight .125)
                       ((rhythms q h q) weight .125)
                       (w weight .125) in random tempo 90)))
  (setf duration rhythm))
