;;; This algorithm will generate a reasonable fake second species 
;;; counterpoint exercise, though I have only reduced (rather than 
;;; excluded) the possibility of repeated notes in the 2nd species 
;;; line. No non-harmonic passing tones in this either:

(in-package :stella)
(in-syntax :midi)

(let (cant spec (phraselength (item (items 8 9 10 11 12 in random)))
           (last-note (make-array 1 :initial-contents '(77))))
  (generator cantus-firmus midi-note (amplitude .3 rhythm 1 duration 1)
    (setf cant 
          (item 
           (degrees d4							    
                    (notes (e4 id e to (items (d weight 3) (f weight 2)  g 
                                              in random))
                           (d4 id d to (items (e weight 2) f a 
                                              in random))
                           (f4 id f to (items (d weight 2) (e weight 2) 
                                              (g weight 2) a in random))
                           (g4 id g to (items (f weight 2) (a weight 3) 
                                              in random))
                           (a4 id a to (items (g weight 2) (bf weight 2) f c 
                                              in random))
                           (bf4 id bf to (a))
                           (c5 id c to (items a bf in random))
                           in graph for phraselength)
                    f4 e d)
           :kill 1))
    (setf note cant))
  
  (generator species2 midi-note (length (* 2 (+ phraselength 4)) 
                                        amplitude .3 rhythm .5 duration .5)
    (cond
     ((equal cant 62)
      (setf spec 
            (item (EXPR
                   (cond ((and (= (abs (- 69 (aref last-note 0))) 
                                  (min (abs (- 69 (aref last-note 0))) 
                                       (abs (- 74 (aref last-note 0)))
                                       (abs (- 77 (aref last-note 0))))) 
                               (/= 0 (- 69 (aref last-note 0)))) 69)
	                 ((and (= (abs (- 74 (aref last-note 0))) 
                                  (min (abs (- 69 (aref last-note 0))) 
                                       (abs (- 74 (aref last-note 0)))
                                       (abs (- 77 (aref last-note 0))))) 
                               (/= 0 (- 74 (aref last-note 0)))) 74)
 	                 ((and (= (abs (- 77 (aref last-note 0))) 
                                  (min (abs (- 69 (aref last-note 0))) 
                                       (abs (- 74 (aref last-note 0)))
                                       (abs (- 77 (aref last-note 0))))) 
                               (/= 0 (- 77 (aref last-note 0)))) 77)
                         (t (item (items 69 74 77 in random for 1))))))))
     ((equal cant 64)
      (setf spec 
            (item (EXPR
                   (cond ((and (= (abs (- 72 (aref last-note 0))) 
                                  (min (abs (- 72 (aref last-note 0))) 
                                       (abs (- 79 (aref last-note 0))))) 
                               (/= 0 (- 72 (aref last-note 0)))) 72)
	                 ((and (= (abs (- 79 (aref last-note 0))) 
                                  (min (abs (- 72 (aref last-note 0))) 
                                       (abs (- 79 (aref last-note 0))))) 
                               (/= 0 (- 79 (aref last-note 0)))) 79)
                         (t (item (items 72 79 in random for 1))))))))
     ((equal cant 65)
      (setf spec 
            (item (EXPR
                   (cond ((and (= (abs (- 69 (aref last-note 0))) 
                                  (min (abs (- 69 (aref last-note 0))) 
                                       (abs (- 72 (aref last-note 0)))
                                       (abs (- 74 (aref last-note 0))))) 
                               (/= 0 (- 69 (aref last-note 0)))) 69)
	                 ((and (= (abs (- 72 (aref last-note 0))) 
                                  (min (abs (- 69 (aref last-note 0))) 
                                       (abs (- 72 (aref last-note 0)))
                                       (abs (- 74 (aref last-note 0))))) 
                               (/= 0 (- 72 (aref last-note 0)))) 72)
 	                 ((and (= (abs (- 74 (aref last-note 0))) 
                                  (min (abs (- 69 (aref last-note 0))) 
                                       (abs (- 72 (aref last-note 0)))
                                       (abs (- 74 (aref last-note 0))))) 
                               (/= 0 (- 74 (aref last-note 0)))) 74)
                         (t (item (items 69 72 74 in random for 1))))))))
     ((equal cant 67)
      (setf spec 
            (item (EXPR
                   (cond ((and (= (abs (- 70 (aref last-note 0))) 
                                  (min (abs (- 70 (aref last-note 0))) 
                                       (abs (- 74 (aref last-note 0)))
                                       (abs (- 76 (aref last-note 0))))) 
                               (/= 0 (- 70 (aref last-note 0)))) 70)
	                 ((and (= (abs (- 74 (aref last-note 0))) 
                                  (min (abs (- 70 (aref last-note 0))) 
                                       (abs (- 74 (aref last-note 0)))
                                       (abs (- 76 (aref last-note 0))))) 
                               (/= 0 (- 74 (aref last-note 0)))) 74)
 	                 ((and (= (abs (- 76 (aref last-note 0))) 
                                  (min (abs (- 70 (aref last-note 0))) 
                                       (abs (- 74 (aref last-note 0)))
                                       (abs (- 76 (aref last-note 0))))) 
                               (/= 0 (- 76 (aref last-note 0)))) 76)
                         (t (item (items 70 74 76 in random for 1))))))))
     ((equal cant 69)
      (setf spec 
            (item (EXPR
                   (cond ((and (= (abs (- 72 (aref last-note 0))) 
                                  (min (abs (- 72 (aref last-note 0))) 
                                       (abs (- 76 (aref last-note 0)))
                                       (abs (- 77 (aref last-note 0))))) 
                               (/= 0 (- 72 (aref last-note 0)))) 72)
	                 ((and (= (abs (- 76 (aref last-note 0))) 
                                  (min (abs (- 72 (aref last-note 0))) 
                                       (abs (- 76 (aref last-note 0)))
                                       (abs (- 77 (aref last-note 0))))) 
                               (/= 0 (- 76 (aref last-note 0)))) 76)
 	                 ((and (= (abs (- 77 (aref last-note 0))) 
                                  (min (abs (- 72 (aref last-note 0))) 
                                       (abs (- 76 (aref last-note 0)))
                                       (abs (- 77 (aref last-note 0))))) 
                               (/= 0 (- 77 (aref last-note 0)))) 77)
                         (t (item (items 72 76 77 in random for 1))))))))
     ((equal cant 70)
      (setf spec 
            (item (EXPR
                   (cond ((and (= (abs (- 74 (aref last-note 0))) 
                                  (min (abs (- 74 (aref last-note 0))) 
                                       (abs (- 77 (aref last-note 0)))
                                       (abs (- 79 (aref last-note 0))))) 
                               (/= 0 (- 74 (aref last-note 0)))) 74)
	                 ((and (= (abs (- 77 (aref last-note 0))) 
                                  (min (abs (- 74 (aref last-note 0))) 
                                       (abs (- 77 (aref last-note 0)))
                                       (abs (- 79 (aref last-note 0))))) 
                               (/= 0 (- 77 (aref last-note 0)))) 77)
 	                 ((and (= (abs (- 79 (aref last-note 0))) 
                                  (min (abs (- 74 (aref last-note 0))) 
                                       (abs (- 77 (aref last-note 0)))
                                       (abs (- 79 (aref last-note 0))))) 
                               (/= 0 (- 79 (aref last-note 0)))) 79)
                         (t (item (items 74 77 79 in random for 1))))))))
     ((equal cant 72)
      (setf spec 
            (item (EXPR
                   (cond ((and (= (abs (- 76 (aref last-note 0))) 
                                  (min (abs (- 76 (aref last-note 0))) 
                                       (abs (- 79 (aref last-note 0)))
                                       (abs (- 81 (aref last-note 0))))) 
                               (/= 0 (- 76 (aref last-note 0)))) 76)
                         ((and (= (abs (- 79 (aref last-note 0))) 
                                  (min (abs (- 76 (aref last-note 0))) 
                                       (abs (- 79 (aref last-note 0)))
                                       (abs (- 81 (aref last-note 0))))) 
                               (/= 0 (- 79 (aref last-note 0)))) 79)
                         ((and (= (abs (- 81 (aref last-note 0))) 
                                  (min (abs (- 76 (aref last-note 0))) 
                                       (abs (- 79 (aref last-note 0)))
                                       (abs (- 81 (aref last-note 0))))) 
                               (/= 0 (- 81 (aref last-note 0)))) 81)
                         (t (item (items 76 79 81 in random for 1))))))))
     (t (setf spec (item (items 74)))))
    (setf note spec)
    (setf (aref last-note 0) spec)))

