;;; This algorithm will generate a reasonable first species counterpoint 
;;; exercise:
;;; 93/07/22: I seem to hear a bug somewhere in this - species1 might be 
;;; giving the lowest 'legal' note instead of the closest 'legal' note to 
;;; its own previous note. I thought I had fixed that with absolute value forms.
;;; Oh well, something to do...

(in-package :stella)
(in-syntax :midi)

(let (cant spec (phraselength (item (items 8 9 10 11 12 in random)))
      (last-note (make-array 1 :initial-contents '(77))))
  (generator cantus-firmus midi-note (amplitude .3 rhythm 1 duration 1)
    (setf cant 
          (item 
           (degrees d4							    
                    (notes (e4 id e to (items (d weight 3) (f weight 2)  g 
                                              in random))
                           (d4 id d to (items (e weight 2) f a 
                                              in random))
                           (f4 id f to (items (d weight 2) (e weight 2) 
                                              (g weight 2) a in random))
                           (g4 id g to (items (f weight 2) (a weight 3) 
                                              in random))
                           (a4 id a to (items (g weight 2) (bf weight 2) f c 
                                              in random))
                           (bf4 id bf to (a))
                           (c5 id c to (items a bf in random))
                           in graph for phraselength)
                    f4 e d)
           :kill 1))
    (setf note cant))

  (generator species1 midi-note (length (+ phraselength 4) amplitude .3 
                                        rhythm 1 duration 1)
    (cond
     ((equal cant 62) 
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 69 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 69)
                         ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 74)
                         ((= (abs (- 77 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 77))))))
     ((equal cant 64) 
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 72 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 79 (aref last-note 0))))) 72)
                         ((= (abs (- 79 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 79 (aref last-note 0))))) 79))))))
     ((equal cant 65) 
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 69 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 72 (aref last-note 0)))
                                  (abs (- 74 (aref last-note 0))))) 69)
                         ((= (abs (- 72 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 72 (aref last-note 0)))
                                  (abs (- 74 (aref last-note 0))))) 72)
                         ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 72 (aref last-note 0)))
                                  (abs (- 74 (aref last-note 0))))) 74))))))
     ((equal cant 67) 
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 70 (aref last-note 0))) 
                             (min (abs (- 70 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 76 (aref last-note 0))))) 70)
                         ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 70 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 76 (aref last-note 0))))) 74)
                         ((= (abs (- 76 (aref last-note 0))) 
                             (min (abs (- 70 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 76 (aref last-note 0))))) 76))))))
     ((equal cant 69) 
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 72 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 76 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 72)
                         ((= (abs (- 76 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 76 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 76)
                         ((= (abs (- 77 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 76 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 77))))))
     ((equal cant 70) 
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 74 (aref last-note 0))) 
                                  (abs (- 77 (aref last-note 0)))
                                  (abs (- 79 (aref last-note 0))))) 74)
                         ((= (abs (- 77 (aref last-note 0))) 
                             (min (abs (- 74 (aref last-note 0))) 
                                  (abs (- 77 (aref last-note 0)))
                                  (abs (- 79 (aref last-note 0))))) 77)
                         ((= (abs (- 79 (aref last-note 0))) 
                             (min (abs (- 74 (aref last-note 0))) 
                                  (abs (- 77 (aref last-note 0)))
                                  (abs (- 79 (aref last-note 0))))) 79))))))
     ((equal cant 72) 
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 76 (aref last-note 0))) 
                             (min (abs (- 76 (aref last-note 0))) 
                                  (abs (- 79 (aref last-note 0)))
                                  (abs (- 81 (aref last-note 0))))) 76)
                         ((= (abs (- 79 (aref last-note 0))) 
                             (min (abs (- 76 (aref last-note 0))) 
                                  (abs (- 79 (aref last-note 0)))
                                  (abs (- 81 (aref last-note 0))))) 79)
                         ((= (abs (- 81 (aref last-note 0))) 
                             (min (abs (- 76 (aref last-note 0))) 
                                  (abs (- 79 (aref last-note 0)))
                                  (abs (- 81 (aref last-note 0))))) 81))))))
     (t (setf spec (item (items 74)))))
    (setf note spec)
    (setf (aref last-note 0) spec)))

