;;; This algorithm changes the rhythm to running 32nd notes for the 
;;; fur Elise motive, and transposes the ds's:
;;; Remember to write both generators simultaneously!

(in-package :stella)
(in-syntax :midi)

(defmultiple-item gesture (rhy frq ampl)
  (:element-period :all)
  (:element-parser (lambda (rhy frq ampl) 
                     (list (rhythm rhy) (note frq) (amplitude ampl)))))


;; these are the variables I may want to change in a motivic transformation
(let (rhythmval noteval ampval)         

(generator ludwig midi-note (length 27)
  (vars (sortout (gesture (rhythms (rhythms e for 8) h)
                          (degrees 64 63 64 63 64 59 62 60 57)
			  (items .2 .2 .25 .3 .35 .3 .25 .22 .2))))

  ;; the EXPR forces a lisp evaluation (no variables in item streams!)
  (let ((tmp (EXPR (item sortout)))) 
    (multiple-item-bind (rhy frq ampl) (item tmp)
       (format t "frq=~S, rhy=~S~& ampl=~S~&~&" frq rhy ampl)
       (setf note frq)
       (setf rhythm rhy)
       (setf amplitude ampl)
       (setf duration rhythm)
       (setf noteval note)
       (setf rhythmval rhythm)
       (setf ampval amplitude))))

(generator ludwig6 midi-note (length 120)
  ;; cond statements sort out what to do with the incoming material
  (cond ((= rhythmval .5) (setf rhythm (item .125)))		
        ((= rhythmval 2) (setf rhythm (item (items .375 .125))))
        (t (setf rhythm rhythmval)))
  (cond ((= noteval 63) (setf note 21))
        (t (setf note noteval)))
  (setf amplitude (* 2 ampval))
  (setf duration (* .5 rhythm))))

