;;; This algorithm changes the rhythm to running 32nd notes for the 
;;; fur Elise motive:
;;; For God's sake remember to write both generators simultaneously! 
;;; After writing both algorithms, listen to ludwig5 by itself.

(in-package :stella)
(in-syntax :midi)

(defmultiple-item gesture (rhy frq ampl)
  (:element-period :all)
  (:element-parser (lambda (rhy frq ampl) 
                     (list (rhythm rhy) (note frq) (amplitude ampl)))))


(let (rhythmval noteval ampval)
  (generator ludwig midi-note (length 27)
    (vars (elise (gesture (rhythms (rhythms e for 8) h)
                            (degrees 64 63 64 63 64 59 62 60 57)
			    (items .2 .2 .25 .3 .35 .3 .25 .22 .2))))

  (let ((tmp (EXPR (item elise))))
    (multiple-item-bind (rhy frq ampl) (item tmp)
       (format t "frq=~S, rhy=~S~& ampl=~S~&~&" frq rhy ampl)
       (setf note frq)
       (setf rhythm rhy)
       (setf amplitude ampl)
       (setf duration rhythm)
       (setf noteval note)
       (setf rhythmval rhythm)
       (setf ampval amplitude))))

(generator ludwig5 midi-note (length 120)
  (cond ((= rhythmval .5) (setf rhythm (item .125)))
        ((= rhythmval 2) (setf rhythm (item (items .375 .125))))
        (t (setf rhythm rhythmval)))
  (setf note noteval)
  (setf amplitude ampval)
  (setf duration rhythm)))

