;;; This algorithm intersperses the fur elise motive and opening of 
;;; the String Quartet Op. 18, no.1:

(in-package :stella)
(in-syntax :midi)

(defmultiple-item gesture (rhy frq ampl)
  (:element-period :all)
  (:element-parser (lambda (rhy frq ampl) 
                     (list (rhythm rhy) (note frq) (amplitude ampl)))))

(generator ludwig4 midi-note (length 50)
  (vars (elise (gesture (rhythms (rhythms e for 8 tempo (tempo 90)) 
                                 h tempo (tempo 90))
                          (degrees 64 63 64 63 64 59 62 60 57)
			  (items .2 .2 .22 .25 .3 .2 .25 .22 .3)))
	(op18 (gesture (rhythms (rhythms h+e s s e e h for 2 
                                         tempo (tempo 120)))
		       (notes f3 g f e f c f g f e f d)
		       (items .4))))

  (let ((tmp (item (items (EXPR (item elise))
                          (EXPR (item op18))
			  in random))))

  (multiple-item-bind (rhy frq ampl) (item tmp)
       (format t "frq=~S, rhy=~S~& ampl=~S~&~&" frq rhy ampl)
       (setf note frq rhythm rhy amplitude ampl duration rhythm))))


