;;; This algorithm generates the Fur Elise motive for a number of 
;;; times specified by the kill command, with an amplitude as well 
;;; as note and rhythm. It works!

(in-package :stella)
(in-syntax :midi)

(defmultiple-item gesture (rhy frq ampl)
  (:element-period :all)
  (:element-parser (lambda (rhy frq ampl) 
                     (list (rhythm rhy) (note frq) (amplitude ampl)))))

(generator ludwig2 midi-note ()
  (vars (elise (gesture (rhythms (rhythms e for 8) h)
                          (degrees 64 63 64 63 64 59 62 60 57)
			  (items .2 .2 .22 .25 .3 .2 .25 .22 .3))))
  (multiple-item-bind (rhy frq ampl) (item elise :kill 2)
      (format t "frq=~S, rhy=~S~& ampl=~S~&~&" frq rhy ampl)
      (setf note frq rhythm rhy amplitude ampl))
  (setf duration rhythm))

