;;; this algorithm generates the Fur Elise motive for a number of 
;;; times specified by the kill command

(in-package :stella)
(in-syntax :midi)

(defmultiple-item gesture (rhy pit)
  (:element-period :all)
  (:element-parser (lambda (rhy pit) (list (rhythm rhy) (note pit)))))

(generator ludwig midi-note (amplitude .3)
  (vars (sortout (gesture (rhythms (rhythms e for 8) h)
                           (degrees 64 63 64 63 64 59 62 60 57))))
  (multiple-item-bind (rhy frq) (item sortout :kill 2)
      (format t "frq=~S, rhy=~S~&" frq rhy)
      (setf note frq rhythm rhy))
  (setf duration rhythm))
