;;; This algorithm will generate a reasonable simulation of Leonin's free 
;;; organum, and combines elements of species2, dorianchant1, and duplum:

(in-package :stella)
(in-syntax :midi)

(let (cant spec (phraselength (item (items 8 9 10 11 12 in random)))
      (last-note (make-array 1 :initial-contents '(77))))
  (generator cantus-firmus midi-note (amplitude .3 rhythm 2.4 duration 2.4)
    (setf cant 
          (item 
           (degrees d4							    
                    (notes (e4 id e to (items (d weight 3) (f weight 2)  g 
                                              in random))
                           (d4 id d to (items (e weight 2) f a 
                                              in random))
                           (f4 id f to (items (d weight 2) (e weight 2) 
                                              (g weight 2) a in random))
                           (g4 id g to (items (f weight 2) (a weight 3) 
                                              in random))
                           (a4 id a to (items (g weight 2) (bf weight 2) f c 
                                              in random))
                           (bf4 id bf to (a))
                           (c5 id c to (items a bf in random))
                           in graph for phraselength)
                    f4 e [d4 d5])
           :kill 1))
    (setf note cant))

  (generator leonin midi-note (amplitude .2 length (* 6 (+ phraselength 3)))
    (cond
     ((equal cant 62)
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 69 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 69)
                         ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 74)
                         ((= (abs (- 77 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 77))))))
     ((equal cant 64)
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 72 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 79 (aref last-note 0))))) 72)
                         ((= (abs (- 79 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 79 (aref last-note 0))))) 79))))))
     ((equal cant 65)
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 69 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 72 (aref last-note 0)))
                                  (abs (- 74 (aref last-note 0))))) 69)
                         ((= (abs (- 72 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 72 (aref last-note 0)))
                                  (abs (- 74 (aref last-note 0))))) 72)
                         ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 69 (aref last-note 0))) 
                                  (abs (- 72 (aref last-note 0)))
                                  (abs (- 74 (aref last-note 0))))) 74))))))
     ((equal cant 67)
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 70 (aref last-note 0))) 
                             (min (abs (- 70 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 76 (aref last-note 0))))) 70)
                         ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 70 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 76 (aref last-note 0))))) 74)
                         ((= (abs (- 76 (aref last-note 0))) 
                             (min (abs (- 70 (aref last-note 0))) 
                                  (abs (- 74 (aref last-note 0)))
                                  (abs (- 76 (aref last-note 0))))) 76))))))
     ((equal cant 69)
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 72 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 76 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 72)
                         ((= (abs (- 76 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 76 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 76)
                         ((= (abs (- 77 (aref last-note 0))) 
                             (min (abs (- 72 (aref last-note 0))) 
                                  (abs (- 76 (aref last-note 0)))
                                  (abs (- 77 (aref last-note 0))))) 77))))))
     ((equal cant 70)
      (setf spec 
            (item (EXPR 
                   (cond ((= (abs (- 74 (aref last-note 0))) 
                             (min (abs (- 74 (aref last-note 0))) 
                                  (abs (- 77 (aref last-note 0)))
                                  (abs (- 79 (aref last-note 0))))) 74)
                         ((= (abs (- 77 (aref last-note 0))) 
                             (min (abs (- 74 (aref last-note 0))) 
                                  (abs (- 77 (aref last-note 0)))
                                  (abs (- 79 (aref last-note 0))))) 77)
                         ((= (abs (- 79 (aref last-note 0))) 
                             (min (abs (- 74 (aref last-note 0))) 
                                  (abs (- 77 (aref last-note 0)))
                                  (abs (- 79 (aref last-note 0))))) 79))))))
	((equal cant 72)
	 (setf spec 
               (item (EXPR 
                      (cond ((= (abs (- 76 (aref last-note 0))) 
                                (min (abs (- 76 (aref last-note 0))) 
                                     (abs (- 79 (aref last-note 0)))
                                     (abs (- 81 (aref last-note 0))))) 76)
                            ((= (abs (- 79 (aref last-note 0))) 
                                (min (abs (- 76 (aref last-note 0))) 
                                     (abs (- 79 (aref last-note 0)))
                                     (abs (- 81 (aref last-note 0))))) 79)
                            ((= (abs (- 81 (aref last-note 0))) 
                                (min (abs (- 76 (aref last-note 0))) 
                                     (abs (- 79 (aref last-note 0)))
                                     (abs (- 81 (aref last-note 0))))) 81))))))
	(t
	 (setf spec (item (items 74)))))
    (setf (aref last-note 0) spec)
    (setf note 
          (item (items (EXPR spec) 
                       (notes (a4 id a4 to (items a4 (c weight 3) d 
                                                  in random))
			      (c5 id c to (items a4 c (d weight 3) e 
                                                 in random))
			      (d5 id d to (items (c weight 2) (e weight 2) 
                                                 a4 d f a in random))
			      (e5 id e to (items (d weight 3) (f weight 2) g 
                                                 in random))
                       	      (f5 id f to (items (d weight 2) (e weight 2) 
                                                 (g weight 2) f a in random))
                       	      (g5 id g to (items (f weight 2) (a weight 3) g 
                                                 in random))
                              (a5 id a to (items (g weight 2) (bf weight 2) a f 
                                                 in random))
                              (bf5 id bf to (a))
			      in graph for 5))))
    (setf rhythm
          (item (rhythms 
                  (rhythms (rhythms q. q e q e q. tempo (tempo 150))
		           ((rhythms q e q e q. q. tempo (tempo 150)) weight 2)
			   (rhythms q. q e q.+e e e tempo (tempo 150))
			   (rhythms q.+e e e q. q e tempo (tempo 150))
			   in random for 3)
	          (rhythms q e e e e h. tempo (tempo 150)))))
  (setf duration rhythm)))

