;;; This algorithm will generate Gregorian chant in Dorian mode with variable 
;;; phrase lengths:

(in-package :stella)
(in-syntax :midi)

(algorithm dorianchant1 midi-note (amplitude .3 channel 0)
  (setf note
        (item 
         (notes d3 c d                              ; fixed beginning
                (notes (notes (notes d3 d e f g )   ; optional phrase openings
                              (notes f3 g) a3 for 1 in random)
                       (notes (e3 id e to (items (d weight 3) (f weight 2)  
                                                 e g in random))
                              (d3 id d to (items (d weight 2) (e weight 2) 
                                                 f a in random))
                              (f3 id f to (items (d weight 2) (e weight 2) 
                                                 (f weight 4) (g weight 2) 
                                                 a in random))
                              (g3 id g to (items (f weight 2) (g weight 2) 
                                                 (a weight 3) in random))
                              (a3 id a to (items (a weight 4) (g weight 2) 
                                                 (bf weight 2) f c in random))
                              (bf3 id bf to (a))
                              ((notes c4 d d c a3)  id c to (a))
                              in graph 
                              for (items 5 6 7 8 9  ; phrase length varies
                                         in random))
                       (notes (notes g3 a f f e d c d d)  ; optional cadences
                              (notes f3 e e d) 
                              (notes g3 f e d d c d) for 1 in random) 
                       (notes r r r r) 	            ; a pause between phrases
                       named phrase)		    ; a label for everything but
                				    ;    the opening three notes
                #@phrase			    ; phrase structure three 
                #@phrase			    ;    more times
                #@phrase )
	      :kill 1))
  (setf rhythm 
        (item (items .37 .38 .39 .4 .41 .42 .43     ; a little offset
                     in random)))
  (setf duration rhythm))




;;; This algorithm will generate chant with an accel. at the beginning of 
;;; each phrase and a rit. at the end of each phrase:

(algorithm dorianchant2 midi-note (amplitude .3 channel 0)
  (vars 
   ;; middlelength represents a variable length for the middle part 
   ;; of the chant phrase
   (middlelength (item (items 5 6 7 in random for 1)))
   ;; env1 is an extremely clumsy envelope which is applied to the rhythmic 
   ;; values of each phrase cause an accel and rit
   (env1 (interpolation 0 				.55 		           
                        7 				.4 
                        (+ middlelength 8) 		.45       
                        (+ middlelength 17) 		.6 
                        (+ middlelength 21) 		.55       
                        (+ middlelength 28) 		.4 
                        (+ (* 2 middlelength) 29) 	.45 
                        (+ (* 2 middlelength) 38) 	.6 
                        (+ (* 2 middlelength) 42) 	.55 
                        (+ (* 2 middlelength) 49) 	.4 
                        (+ (* 3 middlelength) 50) 	.45 
                        (+ (* 3 middlelength) 59) 	.6 
                        (+ (* 3 middlelength) 63) 	.55 
                        (+ (* 3 middlelength) 70) 	.4 
                        (+ (* 4 middlelength) 71) 	.45 
                        (+ (* 4 middlelength) 80) 	.6)))
  ;; this pitch structure is similar to dorianchant1, but the phrases 
  ;; here are of uniform length
  (setf note
        (item (notes ;; phrase openings of fixed length
                (notes (notes d3 c d d e f g a)
                       (notes d3 f a a g a bf a)
                       in random for 1)
                ;; middle sections of variable length
                (notes (e3 id e to (items (d weight 3) (f weight 2) e g 
                                          in random))			 
                       (d3 id d to (items (d weight 2) (e weight 2) f a 
                                          in random))
                       (f3 id f to (items (d weight 2) (e weight 2) 
                                          (f weight 4) (g weight 2) a 
                                          in random))
                       (g3 id g to (items (f weight 2) (g weight 2) 
                                          (a weight 3) in random))
                       (a3 id a to (items (a weight 3) (g weight 2) 
                                          (bf weight 2) f in random))
                       (bf3 id bf to (a))
                       in graph for middlelength) 				
                ;; fixed cadence
                (notes g3 a f f e d c d d)								 
                (notes r for 4))
	      :kill 4))
  (setf rhythm (function-value count env1))
  (setf duration rhythm))


