;;; Esquisse III:
;;;
;;; This sketch is built around a set of six chords and a simple graph 
;;; governing chord progreesions. The first and last chords of the 
;;; algorithm are fixed. Any sort of organ-like synth patch will sound 
;;; good. The shaker algorithm works with a synth patch where Ab3 is a 
;;; tambourine or shaker sample, and the two marimba algorithms (which 
;;; are identical) will work with any keyboard percussion patch. The 
;;; different algorithms are not timed to begin and end together...

(in-package :stella)
(in-syntax :midi)

(generator esquisse3chords midi-note ( amplitude .5 channel 0)
  (setf note
        (item 
         (notes [d2 d3 c4 f e5]         ; fixed first chord
                (notes ([a1 a2 c4 g e5] id a to 
                            (items (g weight 2) bf fs in random))
                       ([c2 c3 d4 g e5] id c to 
                            (items (bf weight 2) d a in random))
                       ([d2 d3 c4 f e5] id d to 
                            (items (c weight 2) bf g in random))
                       ([bf1 bf2 d4 f e5] id bf to 
                             (items (a weight 2) c g in random))
                       ([g1 g2 d4 a f5] id g to 
                            (items (a weight 2) d bf in random))
                       ([fs1 fs2 c4 a e5] id fs to (d))
                                        ; represents random period
                       in graph for (items 10 11 12 13 14 15 16 in random))
                [d2 d3 c4 f e5])
         :kill 1))
 ;(setf note (transpose note 12))       ; for "wrong-octave" patches
  (unless-chording                      ; so that each note of the chord has 
                                        ; the same rhythmic value
    (setf rhythm (item (items 2 3 5 in random))))
  (setf duration rhythm))


;;; Percussion tracks for Esquisse 3: delay the onset of the percussion
;;; for 14 seconds


(generator esquisse3shaker midi-note 
           (length 200 rhythm .25 duration 1 channel 1)
 (setf note
    (item (notes r (56 weight 2) in random)))
 (setf amplitude
    (item (items .3 (.05 weight 3) in random))))

(generator esquisse3marimba1 midi-note 
           (length 200 rhythm .25 duration .3 channel 2)
 (setf note
    (item (notes r 62 64 67 69 72 74 76 79 81 in random)))
 (setf amplitude
    (item (items .7 (.4 weight 3) in random))))

(generator esquisse3marimba2 midi-note 
           (length 200 rhythm .25 duration .3 channel 2)
 (setf note
    (item (notes r 62 64 67 69 72 74 76 79 81 in random)))
 (setf amplitude
    (item (items .7 (.4 weight 3) in random))))

