;;; This algorithm generates a simple duplum voice of a medieval motet:

(in-package :stella)
(in-syntax :midi)

(generator duplum1 midi-note (amplitude .3 channel 0)
  ;; measurelength represents a variable length in measures for the middle 
  ;; part of the duplum phrase
  (vars (measurelength (item (items 2 2 3 in random))))
  ;; this pitch structure is similar to dorianchant1
  (setf note
    (item (notes (notes (d4 weight 2) a in random for 1)
                 (notes (e4 id e to (items (d weight 3) (f weight 2) g 
                                           in random))
			(d4 id d to (items (c weight 2) (e weight 2) d f a 
                                           in random))
                       	(f4 id f to (items (d weight 2) (e weight 2) 
                                           (g weight 2) f a in random))
                       	(g4 id g to (items (f weight 2) (a weight 3) g 
                                           in random))
                        (a4 id a to (items (g weight 2) (bf weight 2) a f 
                                           in random))
                        (bf4 id bf to (a))
                       	(c4 id c to (items (d weight 3) e in random))
			in graph for 50))))
  ;; the rhythm will be killed after 8 phrases
  (setf rhythm
    (item (rhythms 
            (rhythms (rhythms q. q e tempo (tempo 150))
		        ((rhythms q e q e tempo (tempo 150)) weight 2)
			(rhythms q. q. tempo (tempo 150))
			(rhythms q. e e e tempo (tempo 150))
			in random for measurelength)
	    (rhythms h. for 1 tempo (tempo 150)))
	 :kill 8))
  (setf duration rhythm))

;;; a couple of edits are more easily done in the editor:
;;; set end note d4
;;; set end-1 note e                This sets the cadence properly.
