
;;;
;;; This algorithm is similar to to Esquisse but generates a rather difficult
;;; piece for solo cello:
;;;

(in-package :stella)
(in-syntax :midi)

(generator Esquisse4 midi-note (length 200 amplitude .3 channel 0)
  (vars pitch)
  (setf pitch 
        (item 
         (voicings ([0] weight 8) [0 8] [0 9] in random 
                   from 
                   (notes
                     (c2 id c2 to (items c2 (g2 weight 3) (bf2 weight 2) 
                                         (d3 weight 2) e3 fs3 g3 bf3 
                                         in random))
                     (g2 id g2 to (items c2 g2 (bf2 weight 2) c3 d3 e3 fs3 
                                         g3 (bf3 weight 3) d4 in random))
                     (bf2 id bf2 to (items c2 (g2 weight 2) bf2 (c3 weight 2) 
                                           d3 e3 g3 in random))
                     (c3 id c3 to (items c2 g2 bf2 c3 (d3 weight 3) e3 fs3 g3 
                                         (bf3 weight 3) d4 e4 fs4 r in random))
                     (d3 id d3 to (items c2 g2 bf2 c3 d3 e3 fs3 g3 
                                         (bf3 weight 3) d4  in random))
                     (e3 id e3 to (items c2 g2 bf2 c3 d3 e3 (fs3 weight 3) 
                                         (g3 weight 3) bf3 c4 (d4 weight 2) 
                                         fs4 r in random))
                     (fs3 id fs3 to (items g2 c3 d3 (e3 weight 3) fs3 
                                           (g3 weight 3) d4 e4 r in random))
                     (g3 id g3 to (items e3 (fs3 weight 3) g3 (bf3 weight 3) 
                                         c4 d4 e4 fs4 a4 bf4 r in random))
                     (bf3 id bf3 to (items c3 d3 g3 bf3 c4 (d4 weight 3) e4 
                                           g4 a4 c5 r in random))
                     (c4 id c4 to (items d3 e3 bf3 c4 d4 e4 fs4 g4 a4 
                                         (bf4 weight 3) d5 r in random))
                     (d4 id d4 to (items bf3 c4 d4 e4 fs4 g4 a4 bf4 
                                         (c5  weight 3) r in random))
                     (e4 id e4 to (items c2 g2 c3 fs3 bf3 c4 d4 e4 fs4 g4 
                                         bf4 c5 d5 r in random))
                     (fs4 id fs4 to (items e3 g3 c4 d4 (e4 weight 3) 
                                           (g4 weight 3) a4 d5 r in random))
                     (g4 id g4 to (items e3 bf3 e4 fs4 g4 (a4 weight 3) 
                                         bf4 d5 r in random))
                     (a4 id a4 to (items e4 fs4 (g4 weight 3) a4 
                                         (bf4 weight 3) c5 r in random))
                     (bf4 id bf4 to (items g3 c4 d4 g4 c5 d5 r in random))
                     (c5 id c5 to (items e4 fs4 g4 a4 bf4 c5 d5 r in random))
                     (d5 id d5 to (items c4 e4 fs4 g4 a4 bf4 c5 d5 r 
                                         in random))
                     (r id r to (items c2 g2 c3 e3 fs3 g3 bf3 c4 e4 fs4 g4 
                                       a4 bf4 c5 d5 r in random))
                     in graph))))

  (setf note 
        (transpose pitch 
                   (item 
                    (items (items +2 +2 +2 +2 +2 +2 +2 +2 +2 +2 +2)
                           ((items 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) weight 4)
                           (items 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4)
                           (items 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 
                                  7 7 7 7 7 7 7)
                           in random))))

  (unless-chording
    (setf rhythm 
          (item (rhythms 
                  (rhythms h.+tq tq tq tempo (tempo 72))
                  ((rhythms tq tq te te tempo (tempo 72)) weight 2)
                  (rhythms h+e e e e e e tempo (tempo 72))
                  (rhythms te te te+q+te te te tempo (tempo 72))
                  (rhythms h e e e e tempo (tempo 72))
                  (rhythms 16 16 16 16 e+q tq tq tq e e tempo (tempo 72))
                  (rhythms te te te+e e e e tempo (tempo 72))
                  (rhythms h. e e tq tq tq 16 16 16 16 e e e tempo (tempo 72))
                  (rhythms e e te te te tempo (tempo 72))
                  in random))))
  (setf duration rhythm))
  
