;;; **********************************************************************
;;; Copyright (c) 89, 90, 91, 92, 93 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; send to: hkt@zkm.de
;;; **********************************************************************

(in-package :stella)

(defclass csound-score-file (event-file header-mixin)
  ((orchestra :initarg orchestra :initform nil)
   (output :initarg output :initform nil)
   (syntax :initform (find-syntax ':csound))))

(defclass csound-score-file (event-file header-mixin)
  ((syntax :initform (find-syntax ':csound))))

(defmethod open-event-stream ((syntax csound) &rest args)
  (apply #'open-event-stream (find-class 'csound-score-file) args))

(defmethod initialize-stream-for-processing ((stream csound-score-file))
  (let ((file (slot-value stream 'stream)))
    (format file "; Stella output ~A~%~%" (cm::date-string))
    (when (slot-boundp stream 'header)
      (format file "~A~%" (slot-value stream 'header)))
    (format file "~&s~%")))

(defmethod deinitialize-stream-for-processing ((stream csound-score-file))
  (let ((file (slot-value stream 'stream)))
    (format file "e~%")))

(defmethod play-using-syntax ((syntax csound) file &rest args)
	(declare (ignore args))
  #+mcl (format t "Sorry, can't play csound from Lisp on the Mac.~%")
  #-mcl	(let* ((ofile  (slot-value (find-stream file) 'output))
		(orc  (slot-value (find-stream file) 'orchestra))
		(command (format nil "~Aunix/playcsound -o ~A ~A ~A"
					*common-music-directory* ofile orc
					(namestring (truename file))))
		(plcmd (format nil "~Aunix/playsnd ~A"
					*common-music-directory* ofile)))
		(cm::shell command)
		(tell-user "Playing ~A ." ofile)
		(cm::shell plcmd)))

