;;; **********************************************************************
;;; Copyright (c) 89-93, 94 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  Suggestions, comments and bug reports are welcome.  Please 
;;; address email to: hkt@zkm.de
;;; **********************************************************************

(in-package :stella)

#-clisp
(defun copy-object (element &optional block)
  (copy-object-using-class (class-of element) element block))

#+clisp
(progn
(defmethod copy-object ((element t) &optional block)
  (copy-object-using-class (class-of element) element block))

(defmethod copy-object ((element generator) &optional block)
  (copy-object-using-class (find-class 'thread) element block))
)

  
(defmethod fill-object-using-class ((class standard-class) 
                                     e1 e2 &optional block)
  (let ((slots (class-slots class)))
    (if block
        (dolist (s slots)
          (when (slot-boundp-using-class class e2 s)
	    (unless (find (slot-definition-name s) block :test #'eq)	       
	      (setf (slot-value-using-class class e1 s)
                (slot-value-using-class class e2 s)))))
      (dolist (s slots)
        (when (slot-boundp-using-class class e2 s)
	  (setf (slot-value-using-class class e1 s)
            (slot-value-using-class class e2 s))))))
  e1)
  
(defmethod copy-object-using-class ((class standard-class) 
                                     (element t)
				     &optional block)
  (let ((new (make-instance class)))
    (fill-object-using-class class new element block)
    new)) 

#-(and clisp (not pcl))
(progn

(defmethod copy-object-using-class :around ((class standard-class)
                                            (element id-mixin) 
                                            &optional block)
  (call-next-method class element (list* 'id block)))  

(defmethod copy-object-using-class :around ((class standard-class)
                                            (element container-mixin)
                                             &optional block)
  (call-next-method class element (list* 'container block)))

(defmethod copy-object-using-class :around ((class standard-class)
                                             (element container)
                                             &optional block)
  (call-next-method class element (list* 'elements block)))

(defmethod copy-object-using-class :around ((class standard-class)
                                             (element thread)
                                             &optional block)
  (let ((new (call-next-method class element (list* 'flags block))))
    (loop for e in (container-objects element)
          do (add-object (copy-object e) new))
    new))

(defmethod copy-object-using-class :around ((class standard-class)
                                             (element generator)
                                             &optional block)
  (call-next-method (find-class 'thread) element block))
) ; #-(and clisp (not pcl))


#+(and clisp (not pcl)) ; call-next-method can't take args in some CLISPs
(progn

(defmethod copy-object-using-class :around ((class standard-class)
                                           (object id-mixin)
                                           &optional block)
  (declare (ignore block))
  (let ((id (slot-value object 'id)))
    (unwind-protect
      (progn (slot-makunbound object 'id)
             (call-next-method))
      (setf (slot-value object 'id) id)))
   )
    
(defmethod copy-object-using-class :around ((class standard-class)
                                           (object container-mixin)
                                           &optional block)
  (declare (ignore block))
  (let ((new (call-next-method)))
    (slot-makunbound new 'container)
    new))

(defmethod copy-object-using-class :around ((class standard-class)
                                           (object container)
                                           &optional block)
  (declare (ignore block))
  (let ((new (call-next-method)))
    (setf (slot-value new 'elements) (make-bag))
    new))

(defmethod copy-object-using-class :around ((class standard-class)
                                            (object thread)
                                            &optional block)
  (declare (ignore block))
  (let ((new (call-next-method)))
    (setf (slot-value new 'flags) 0)
    (dolist (sub (container-objects object))
      (add-object (copy-object sub) new))
     new))

) ; #+(and clisp (not pcl))

