;;; -*- Mode: LISP; Syntax: Common-lisp; Package: COMMON-MUSIC; Base: 10 -*-
;;; **********************************************************************
;;; Copyright (c) 1989, 1990 Heinrich Taube.  All rights reserved.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted and may be copied as long as 
;;; no fees or compensation are charged for use, copying, or accessing
;;; this software and all copies of this software include this copyright
;;; notice.  No warranty is made about this software, its performance
;;; or its conformity to any specification.  Any distribution of this 
;;; software must comply with all applicable United States export control
;;; laws. Suggestions, comments and bug reports are welcome.  Please 
;;; address electronic correspondence to: hkt@ccrma.stanford.edu
;;; **********************************************************************

(in-package "COMMON-MUSIC")

(defclass NOTE-STREAM-MIXIN ()
  ((scale :accessor note-stream-scale :initarg :scale)))

(defclass NOTE-MIXIN (note-stream-mixin) ())
(defclass DEGREE-MIXIN (note-stream-mixin) ())
(defclass PITCH-MIXIN (note-stream-mixin) ())

;;;
;;; The item methods for the various note stream mixins return either
;;; the name, step or pitch of the notes in the stream.
;;;

(defmethod ITEM :around ((stream NOTE-MIXIN))
  (declare (optimize (speed 3)(safety 0)))
  (multiple-value-bind (note state) (call-next-method)
    (values (scale-note note (slot-value stream 'scale))
            state)))

(defmethod ITEM :around ((stream DEGREE-MIXIN))
  (declare (optimize (speed 3)(safety 0)))
  (multiple-value-bind (note state) (call-next-method)
    (values (scale-degree note (slot-value stream 'scale))
            state)))

(defmethod ITEM :around ((stream PITCH-MIXIN))
  (declare (optimize (speed 3)(safety 0)))
  (multiple-value-bind (note state) (call-next-method)
    (values (scale-pitch note (slot-value stream 'scale))
            state)))

;;;
;;; Note, degree and pitch stream definitions
;;;

(defclass CYCLIC-NOTE-STREAM (note-mixin cyclic-item-stream) ())
(defclass CYCLIC-DEGREE-STREAM (degree-mixin cyclic-item-stream) ())
(defclass CYCLIC-PITCH-STREAM (pitch-mixin cyclic-item-stream)()) 

(defclass SEQUENTIAL-NOTE-STREAM (note-mixin sequential-item-stream) ())
(defclass SEQUENTIAL-DEGREE-STREAM (degree-mixin sequential-item-stream) ())
(defclass SEQUENTIAL-PITCH-STREAM (pitch-mixin sequential-item-stream)()) 

(defclass ACCUMULATING-NOTE-STREAM (note-mixin accumulating-item-stream) ())
(defclass ACCUMULATING-DEGREE-STREAM (degree-mixin accumulating-item-stream) ())
(defclass ACCUMULATING-PITCH-STREAM (pitch-mixin accumulating-item-stream)()) 

(defclass HEAP-NOTE-STREAM (note-mixin heap-item-stream) ())
(defclass HEAP-DEGREE-STREAM (degree-mixin heap-item-stream) ())
(defclass HEAP-PITCH-STREAM (pitch-mixin heap-item-stream) ())

(defclass RANDOM-NOTE-STREAM (note-mixin random-item-stream) ())
(defclass RANDOM-DEGREE-STREAM (degree-mixin random-item-stream) ())
(defclass RANDOM-PITCH-STREAM (pitch-mixin random-item-stream) ())

(defclass GRAPH-NOTE-STREAM (note-mixin graph-item-stream) ())
(defclass GRAPH-DEGREE-STREAM (degree-mixin graph-item-stream) ())
(defclass GRAPH-PITCH-STREAM (pitch-mixin graph-item-stream) ())

(defclass FUNCTIONAL-NOTE-STREAM (note-mixin functional-item-stream) ())
(defclass FUNCTIONAL-DEGREE-STREAM (degree-mixin functional-item-stream) ())
(defclass FUNCTIONAL-PITCH-STREAM (pitch-mixin functional-item-stream) ())

;;;
;;; Chord streams
;;;

(defclass CHORD-STREAM-MIXIN () ())

;;;
;;; The around method on item for chord streams returns the state :chording
;;; if the stream is not at its end.
;;;

(defmethod ITEM :around ((stream CHORD-STREAM-MIXIN)) 
  (declare (optimize (speed 3)(safety 0)))
  (multiple-value-bind (datum state) 
      (call-next-method)
    (values datum (or state ':chording))))   


;;;(defclass HEAP-CHORD-STREAM (chord-stream-mixin heap-item-stream) ())
;;;(defclass RANDOM-CHORD-STREAM (chord-stream-mixin random-item-stream) ())

(defclass CHORD-STREAM (chord-stream-mixin cyclic-item-stream) ())
(defclass NOTE-CHORD-STREAM (chord-stream-mixin cyclic-note-stream) ())
(defclass PITCH-CHORD-STREAM (chord-stream-mixin cyclic-pitch-stream) ())
(defclass DEGREE-CHORD-STREAM (chord-stream-mixin cyclic-degree-stream) ())
