;;; -*- Mode: Lisp; Syntax: Common-lisp; Package: common-music; Base: 10 -*-

(in-package :common-music)

(eval-when (load compile eval)
  (setf (get 'm1waveform :param-id) 48)
  (setf (get 'm2indatt :param-id) 109)
  (setf (get 'portamento :param-id) 33)
  (setf (get 'waveform1 :param-id) 34)
  (setf (get 'm2ind1 :param-id) 51)
  (setf (get 'amp1 :param-id) 30)
  (setf (get 'svibfreq0 :param-id) 120)
  (setf (get 'noiseamp :param-id) 75)
  (setf (get 'relvelocity :param-id) 17)
  (setf (get 'm2ind0 :param-id) 108)
  (setf (get 'waveform :param-id) 34)
  (setf (get 'balancesensitivity :param-id) 25)
  (setf (get 'monochans :param-id) 15)
  (setf (get 'm2indenv :param-id) 107)
  (setf (get 'ampatt :param-id) 83)
  (setf (get 'svibfreq1 :param-id) 67)
  (setf (get 'noiseampenv :param-id) 135)
  (setf (get 'waveform0 :param-id) 92)
  (setf (get 'basicchan :param-id) 13)
  (setf (get 'pitchbendsensitivity :param-id) 28)
  (setf (get 'm2ind :param-id) 51)
  (setf (get 'wavelen :param-id) 35)
  (setf (get 'aftertouch :param-id) 2)
  (setf (get 'sysrealtime :param-id) 12)
  (setf (get 'waveformatt :param-id) 93)
  (setf (get 'm2ratio :param-id) 50)
  (setf (get 'amprel :param-id) 84)
  (setf (get 'svibamp0 :param-id) 128)
  (setf (get 'noiseamp0 :param-id) 136)
  (setf (get 'aftertouchsensitivity :param-id) 20)
  (setf (get 'pansensitivity :param-id) 26)
  (setf (get 'chanmode :param-id) 11)
  (setf (get 'bearing :param-id) 31)
  (setf (get 'bright :param-id) 32)
  (setf (get 'sysexclusive :param-id) 10)
  (setf (get 'waveformrel :param-id) 94)
  (setf (get 'freqenv :param-id) 77)
  (setf (get 'svibamp1 :param-id) 68)
  (setf (get 'noiseamp1 :param-id) 75)
  (setf (get 'cratio :param-id) 37)
  (setf (get 'tunerequest :param-id) 9)
  (setf (get 'm1ind :param-id) 47)
  (setf (get 'songselect :param-id) 8)
  (setf (get 'waveformenv :param-id) 91)
  (setf (get 'velocitysensitivity :param-id) 19)
  (setf (get 'freq0 :param-id) 78)
  (setf (get 'rvibamp :param-id) 70)
  (setf (get 'noiseampatt :param-id) 137)
  (setf (get 'm1ind0 :param-id) 104)
  (setf (get 'songposition :param-id) 7)
  (setf (get 'freq :param-id) 29)
  (setf (get 'm1ind1 :param-id) 47)
  (setf (get 'timecodeq :param-id) 6)
  (setf (get 'freq1 :param-id) 29)
  (setf (get 'keynum :param-id) 18)
  (setf (get 'noiseamprel :param-id) 138)
  (setf (get 'm1indatt :param-id) 105)
  (setf (get 'programchange :param-id) 5)
  (setf (get 'velocity :param-id) 16)
  (setf (get 'soundfile :param-id) 193)
  (setf (get 'm1indenv :param-id) 103)
  (setf (get 'keypressure :param-id) 1)
  (setf (get 'freqatt :param-id) 79)
  (setf (get 'controlval :param-id) 14)
  (setf (get 'breathsensitivity :param-id) 22)
  (setf (get 'm1indrel :param-id) 106)
  (setf (get 'm2phase :param-id) 53)
  (setf (get 'ampenv :param-id) 81)
  (setf (get 'svibfreq :param-id) 67)
  (setf (get 'amp :param-id) 30)
  (setf (get 'pitchbend :param-id) 4)
  (setf (get 'm1phase :param-id) 49)
  (setf (get 'phase :param-id) 36)
  (setf (get 'm2waveform :param-id) 52)
  (setf (get 'freqrel :param-id) 80)
  (setf (get 'controlchange :param-id) 3)
  (setf (get 'm1ratio :param-id) 46)
  (setf (get 'timeoffset :param-id) 194)
  (setf (get 'm2indrel :param-id) 110)
  (setf (get 'amp0 :param-id) 82)
  (setf (get 'svibamp :param-id) 68)
	   
  (setf (get 'm1waveform :coerce) :QUOTED-STRING)
  (setf (get 'm2indatt :coerce) :FLOAT)
  (setf (get 'portamento :coerce) :FLOAT)
  (setf (get 'waveform1 :coerce) :QUOTED-STRING)
  (setf (get 'm2ind1 :coerce) :FLOAT)
  (setf (get 'svibfreq0 :coerce) :FLOAT)
  (setf (get 'amp1 :coerce) :FLOAT)
  (setf (get 'noiseamp :coerce) :FLOAT)
  (setf (get 'relvelocity :coerce) :INTEGER)
  (setf (get 'm2ind0 :coerce) :FLOAT)
  (setf (get 'waveform :coerce) :QUOTED-STRING)
  (setf (get 'balancesensitivity :coerce) :INTEGER)
  (setf (get 'monochans :coerce) :INTEGER)
  (setf (get 'm2indenv :coerce) :QUOTED-STRING)
  (setf (get 'svibfreq1 :coerce) :FLOAT)
  (setf (get 'ampatt :coerce) :FLOAT)
  (setf (get 'noiseampenv :coerce) :QUOTED-STRING)
  (setf (get 'waveform0 :coerce) :QUOTED-STRING)
  (setf (get 'basicchan :coerce) :INTEGER)
  (setf (get 'pitchbendsensitivity :coerce) :INTEGER)
  (setf (get 'm2ind :coerce) :FLOAT)
  (setf (get 'wavelen :coerce) :INTEGER)
  (setf (get 'aftertouch :coerce) :INTEGER)
  (setf (get 'sysrealtime :coerce) :INTEGER)
  (setf (get 'waveformatt :coerce) :FLOAT)
  (setf (get 'm2ratio :coerce) :FLOAT)
  (setf (get 'svibamp0 :coerce) :FLOAT)
  (setf (get 'amprel :coerce) :FLOAT)
  (setf (get 'noiseamp0 :coerce) :FLOAT)
  (setf (get 'aftertouchsensitivity :coerce) :INTEGER)
  (setf (get 'pansensitivity :coerce) :INTEGER)
  (setf (get 'chanmode :coerce) :INTEGER)
  (setf (get 'bearing :coerce) :FLOAT)
  (setf (get 'bright :coerce) :FLOAT)
  (setf (get 'sysexclusive :coerce) :QUOTED-STRING)
  (setf (get 'waveformrel :coerce) :FLOAT)
  (setf (get 'decay :coerce) :FLOAT)
  (setf (get 'svibamp1 :coerce) :FLOAT)
  (setf (get 'freqenv :coerce) :QUOTED-STRING)
  (setf (get 'noiseamp1 :coerce) :FLOAT)
  (setf (get 'cratio :coerce) :FLOAT)
  (setf (get 'tunerequest :coerce) :INTEGER)
  (setf (get 'lowestfreq :coerce) :PITCH)
  (setf (get 'm1ind :coerce) :FLOAT)
  (setf (get 'songselect :coerce) :INTEGER)
  (setf (get 'waveformenv :coerce) :QUOTED-STRING)
  (setf (get 'velocitysensitivity :coerce) :INTEGER)
  (setf (get 'picknoise :coerce) :FLOAT)
  (setf (get 'rvibamp :coerce) :FLOAT)
  (setf (get 'freq0 :coerce) :PITCH)
  (setf (get 'noiseampatt :coerce) :FLOAT)
  (setf (get 'm1ind0 :coerce) :FLOAT)
  (setf (get 'songposition :coerce) :INTEGER)
  (setf (get 'sustain :coerce) :FLOAT)
  (setf (get 'freq :coerce) :PITCH)
  (setf (get 'm1ind1 :coerce) :FLOAT)
  (setf (get 'timecodeq :coerce) :INTEGER)
  (setf (get 'freq1 :coerce) :PITCH)
  (setf (get 'keynum :coerce) :INTEGER)
  (setf (get 'noiseamprel :coerce) :FLOAT)
  (setf (get 'm1indatt :coerce) :FLOAT)
  (setf (get 'programchange :coerce) :INTEGER)
  (setf (get 'velocity :coerce) :INTEGER)
  (setf (get 'm1indenv :coerce) :QUOTED-STRING)
  (setf (get 'keypressure :coerce) :INTEGER)
  (setf (get 'freqatt :coerce) :FLOAT)
  (setf (get 'controlval :coerce) :INTEGER)
  (setf (get 'breathsensitivity :coerce) :INTEGER)
  (setf (get 'm1indrel :coerce) :FLOAT)
  (setf (get 'm2phase :coerce) :FLOAT)
  (setf (get 'svibfreq :coerce) :FLOAT)
  (setf (get 'ampenv :coerce) :QUOTED-STRING)
  (setf (get 'amp :coerce) :FLOAT)
  (setf (get 'pitchbend :coerce) :INTEGER)
  (setf (get 'm1phase :coerce) :FLOAT)
  (setf (get 'phase :coerce) :FLOAT)
  (setf (get 'm2waveform :coerce) :QUOTED-STRING)
  (setf (get 'freqrel :coerce) :FLOAT)
  (setf (get 'controlchange :coerce) :INTEGER)
  (setf (get 'm1ratio :coerce) :FLOAT)
  (setf (get 'm2indrel :coerce) :FLOAT)
  (setf (get 'svibamp :coerce) :FLOAT)
  (setf (get 'amp0 :coerce) :FLOAT)
)

(eval-when (load compile eval)
 (require :objc)
 (defvar *mk-listener* "/dist/220/Apps/MKLisp")
 (defvar already-loaded nil)
 (unless already-loaded
   (load "/dist/220/Apps/obj/MySpeaker.o" )
   (load "/dist/220/Apps/obj/ExampApp.o" )

#|   (load "/dist/220/Apps/obj/MySpeaker.o" 
         :foreign-files '("/usr/lib/libNeXT_s.a" "/usr/lib/libmusic_s.a")
         :system-libraries '("sys_s"))
   (load "/dist/220/Apps/obj/ExampApp.o" 
         :foreign-files '("/usr/lib/libNeXT_s.a" "/usr/lib/libmusic_s.a")
         :system-libraries '("sys_s"))
|#
   (setf already-loaded t)))

(ff:defforeign 'setup :arguments '() :return-type :integer)
(ff:defforeign 'note  :arguments '(integer float float integer integer)
               :return-type :integer)
(ff:defforeign 'quit  :arguments '() :return-type :integer)
(ff:defforeign 'reorchestrate  :arguments '() :return-type :integer)
(ff:defforeign 'paramid  :arguments '(string) :return-type :integer)
(ff:defforeign 'makenotedur  :arguments '(integer float)
               :return-type :integer)
(ff:defforeign 'makenoteupdate  :arguments '(integer) :return-type :integer)
(ff:defforeign 'sendnotedur  :arguments '(integer float)
               :return-type :integer)
(ff:defforeign 'sendnoteupdate  :arguments '(integer float)
               :return-type :integer)
(ff:defforeign 'addfloatparam  :arguments '(integer integer float) 
               :return-type :integer)
(ff:defforeign 'addstringparam  :arguments '(integer integer string) 
               :return-type :integer)
(ff:defforeign 'addintparam  :arguments '(integer integer integer) 
               :return-type :integer)

(defclass mklisp-score (score)
  ((header :accessor scorefile-header :initarg :header
	   :initarg header :initform *default-scorefile-header*
	   :documentation "A header string for the output file.")
   (dsporchestra :initform "~/.mkcm.score")))

(eval-when (compile load eval)	   
  (setf (get ':musicKit :score) 'mklisp-score))

(defmethod initialize-instance :after ((score mklisp-score) &rest args)
  (declare (ignore args))
  (setf *music-kit-unique-part-tag* 0))

(eval-when (load eval)
  (utils:initialize-resource 'scores 1 'mklisp-score))

(defvar *mklisp-listening* nil) 

(defun mklisp-start-listening ()
  (if *mklisp-listening*
      (progn (reorchestrate))
    (progn
      ;; listener always present in Lisp App
      ;; (shell (format nil "open ~a" *mk-listener*))       
      (setf *mklisp-listening* t)
      (setup)
      (sleep 2)
      (reorchestrate))))
   
  

(defun mklisp-stop-listening () 
  (setf *mklisp-listening* nil))

(defmethod schedule-score-events :before ((score mklisp-score))
  (with-open-file (*common-music-output* (slot-value score 'dsporchestra)
					 :direction :output :if-exists :supersede)
		  
    (format *common-music-output*  
	        "/* Common Music output (MKLisp DSP Orchestra) ~A */~%~%" 
			(date-string))
    (when (slot-boundp score 'header)
      (let ((header (slot-value score 'header)))	   
        (when header (format *common-music-output* "~&~a~%" header))))
    (loop for x in (slot-value score 'events)
	      do (print-part-info (if (consp x) (car x) x)    
	      *common-music-output*))	    )
    (mklisp-start-listening))

(defmethod make-score-event-method ((score mklisp-score)
				    (part music-kit-poly-part)
				    class-name parameters)
  `(defmethod score-event ((part ,class-name) (score mklisp-score))
     (declare (optimize (speed 3)(safety 0)))
     ;; print the name and duration
     (let ((part-tag (slot-value part 'part-tag)))
       (make-notedur part-tag  
                     (or (slot-value part 'duration)(slot-value part 'rhythm)))					       
         ,.(loop for par in parameters
                 append (mklisp-parameter-forms part par 'part-tag
		                              (get (pinfo-name par) :param-id))) 
       (send-notedur part-tag (slot-value part 'time)))))

(defun mklisp-parameter-forms (part pinfo nt paramid)
  (declare (ignore part))
  (unless (eq (pinfo-type pinfo) ':message)
    (error "MusicKit only supports &message parameters."))
  (let ((var (gentemp "V")))
    `((let ((,var (slot-value part ',(pinfo-name pinfo))))
        (when ,var ,(mklisp-value-form var pinfo paramid nt))))))

(defun mklisp-value-form (value pinfo paramid notetag)
  (let ((name (pinfo-name pinfo))
        value-type)
    (setf value-type (get name ':coerce))
    (if value-type
        (ecase value-type
	  (:pitch 
	    `(add-float-param ,paramid ,notetag 
                          (scale-pitch ,value *standard-scale*)))
	  (:float 
	    `(add-float-param ,paramid ,notetag (float ,value)))
	  (:quoted
	    `(add-string-param ,paramid ,notetag ,value))
          (:quoted-string
	    `(add-string-param ,paramid ,notetag ,value))
	  (:integer
	    `(add-int-param ,paramid ,notetag (floor ,value))))
      `(error "attempt to send unknown parameter value-type to MK, ~s ~A~%"
	          ,value-type (write-to-string (quote ,name))))))

(defun make-notedur (notetag dur) 
  (makenotedur notetag (float dur))) 

(defun make-noteupdate (notetag) 
  (makenoteupdate notetag)) 

(defun send-notedur (notetag time) 
  (sendnotedur notetag (float time))) 

(defun send-noteupdate (notetag time) 
  (sendnoteupdate notetag (float time))) 

(defun add-float-param (paramid notetag val) 
  (addfloatparam paramid notetag val)) 

(defun  add-string-param (paramid notetag val) 
  (addstringparam paramid notetag val)) 

(defun add-int-param (paramid notetag val) 
  (addintparam paramid notetag val)) 

(defmacro defscore (options &body body &environment environment)
      (when *mklisp-listening* 
        (when (= 1 (reorchestrate)) 
	  (reorchestrate) ; user aborted a play, so resync
	   )) 
      (compute-score-expansion :score options body environment))

(defun make-listener-method (part-name)
;  (format t "making ~S~%" part-name)
  (let* ((score-class (find-class 'mklisp-score))
         (part-class (find-class part-name))
         (parameters (class-parameters part-class)))
    (make-score-event-method (class-prototype score-class)
	                         (class-prototype part-class)
                             part-name parameters)))

(defmacro deflistener-method (part)
  (make-listener-method `,part))



