;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

(in-package "COMMON-MUSIC")

;;;
;;; This file depends on mk-mixins.lisp
;;;

(defpart mkPluck (synth-patch-mixin standard-music-kit-mixin)
	 (&message freq keyNum pitchBend pitchBendSensitivity bearing
		   amp velocity velocitySensitivity controlChange controlVal
		   lowestFreq sustain pickNoise decay bright ampRel)
  ((lowestFreq :initarg lowestfreq :message "lowestFreq:")
   (sustain :initarg sustain :message "sustain:")
   (pickNoise :initarg picknoise :message "pickNoise:")
   (decay :initarg decay :message "decay:")   
   (bright :initarg bright :message "bright:")
   (ampRel :initarg amprel :message "ampRel:")
   (patch :initform "Pluck"))
  :define-event-method nil
  :define-resource nil)


(defpart PluckMono (mkPluck music-kit-mono-part) 
	 ()
  ()
  :define-event-method t)


(defpart PluckPoly (mkPluck music-kit-poly-part) 
	 ()
  ()
  :define-event-method t)

