;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

(in-package "COMMON-MUSIC")

;;;
;;; synthpatch mixin
;;;

(defclass synth-patch-mixin ()
  ((synthPatchCount :initarg :synthPatchCount :initarg synthPatchCount
		    :initform nil :reader music-kit-synth-patch-count)
   (patch :allocation :class :reader music-kit-synth-patch)))


;;;
;;; basic parameter mixin
;;;

(defpart standard-music-kit-mixin ()
	 (&message freq keyNum pitchBend pitchBendSensitivity bearing
		   amp velocity velocitySensitivity controlChange controlVal)
  ((freq :initarg freq :message "freq:")
   (keyNum :initarg keyNum :message "keyNum:")
   (pitchBend :initarg pitchBend :message "pitchBend:")
   (pitchBendSensitivity :initarg pitchBendSensitivity 
			 :message "pitchBendSensitivity:")
   (bearing :initarg bearing :message "bearing:")
   (amp :initarg amp :message "amp:")
   (velocity :initarg velocity :message  "velocity:")
   (velocitySensitivity :initarg velocitySensitivity 
			:message "velocitySensitivity:")
   (controlChange :initarg controlChange :message "controlChange:")
   (controlVal :initarg controlVal :message "controlVal:"))
  :define-event-method nil
  :define-resource nil)

;;;
;;; waveform mixins
;;;

(defpart standard-oscillator-mixin ()
	 (&message ampEnv amp0 amp1 ampAtt ampRel freqEnv freq0 freq1
		   freqAtt freqRel portamento waveform waveLen phase)
  ((ampEnv :initarg ampEnv :message "ampEnv:")
   (amp0 :initarg amp0 :message "amp0:")
   (amp1 :initarg amp1 :message "amp1:")
   (ampAtt :initarg ampAtt :message "ampAtt:")
   (ampRel :initarg ampRel :message "ampRel:")
   (freqEnv :initarg freqEnv :message "freqEnv:")
   (freq0 :initarg freq0 :message "freq0:")
   (freq1 :initarg freq1 :message "freq1:")
   (freqAtt :initarg freqAtt :message "freqAtt:")
   (freqRel :initarg freqRel :message "freqRel:")
   (portamento :initarg portamento :message "portamento:")
   (waveform :initarg waveform :message "waveform:")
   (waveLen :initarg wavelen :message "waveLen:")
   (phase :initarg phase :message "phase:"))
  :define-event-method nil
  :define-resource nil)

(defpart waveform0-mixin ()
	 (&message waveform0 waveform1)
  ((waveform0 :initarg waveform0 :message "waveform0:")
   (waveform1 :initarg waveform1 :message "waveform1:"))
  :define-event-method nil
  :define-resource nil)

(defpart waveform-envelope-mixin (waveform0-mixin)
	 (&message waveform0 waveform1 waveformAtt waveformRel waveformEnv)
  ((waveformAtt :initarg waveformAtt :message "waveformAtt:")
   (waveformRel :initarg waveformRel :message "waveformRel:")
   (waveformEnv :initarg waveformEnv :message "waveformEnv:"))
  :define-event-method nil
  :define-resource nil)

;;;
;;; vibrato mixins
;;;   

(defpart vibrato-mixin ()
	 (&message sVibFreq sVibAmp sVibFreq0 sVibFreq1 
		   sVibAmp0 sVibAmp1 rVibAmp)
  ((sVibFreq :initarg svibfreq :message "svibFreq:")
   (sVibAmp :initarg svibamp :message "svibAmp:")
   (sVibFreq0 :initarg svibfreq0 :message "svibFreq0:")
   (sVibFreq1 :initarg svibfreq1 :message "svibFreq1:")
   (sVibAmp0 :initarg svibamp0 :message "svibAmp0:")
   (sVibAmp1 :initarg svibamp1 :message "svibAmp1:")
   (rVibAmp :initarg rvibamp :message "rvibAmp:"))
  :define-event-method nil
  :define-resource nil)

;;;
;;; noise mixins
;;;

(defpart noise-modulation-mixin ()
	 (&message noiseAmp noiseAmpEnv noiseAmp0 noiseAmp1
		   noiseAmpAtt noiseAmpRel breathSensitivity)
  ((noiseAmp :initarg noiseamp :message "noiseAmp:")
   (noiseAmpEnv :initarg noiseampenv :message "noiseAmpEnv:")
   (noiseAmp0 :initarg noiseamp0 :message "noiseAmp0:")
   (noiseAmp1 :initarg noiseamp1 :message "noiseAmp1:")
   (noiseAmpAtt :initarg noiseampatt :message "noiseAmpAtt:")
   (noiseAmpRel :initarg noiseamprel :message "noiseAmpRel:")
   (breathSensitivity :initarg breathSensitivity 
		      :message "breathSensitivity:"))
  :define-event-method nil
  :define-resource nil)

(defpart midi-panning-mixin ()
	 (&message panSensitivity)
  ((panSensitivity :initarg panSensitivity :message "panSensitivity:"))
  :define-event-method nil
  :define-resource nil)

(defpart midi-balance-mixin ()
	 (&message balanceSensitivity)
  ((balanceSensitivity :initarg balanceSensitivity
		       :message "balanceSensitivity:"))
  :define-event-method nil
  :define-resource nil)

;;;
;;; frequency modulation mixins
;;;

(defpart fm-mixin ()
	 (&message cRatio m1Ratio m1Ind m1IndEnv m1Ind0 m1Ind1
		   m1IndAtt m1IndRel m1Waveform m1Phase bright afterTouch
		   afterTouchSensitivity)
  ((cRatio :initarg cratio :message "cRatio:")
   (m1Ratio :initarg m1ratio :message "m1Ratio:")
   (m1Ind :initarg m1ind :message "m1Ind:")
   (m1IndEnv :initarg m1indenv :message "m1IndEnv:")
   (m1Ind0 :initarg m1ind0 :message "m1Ind0:")
   (m1Ind1 :initarg m1ind1 :message "m1Ind1:")
   (m1IndAtt :initarg m1indatt :message "m1IndAtt:")
   (m1IndRel :initarg m1indrel :message "m1IndRel:")
   (m1Waveform :initarg m1waveform :message "m1Waveform:")
   (m1Phase :initarg m1phase :message "m1Phase:")
   (bright :initarg bright :message "bright:")
   (afterTouch :initarg afterTouch :message "afterTouch:")
   (afterTouchSensitivity :initarg afterTouchSensitivity 
			  :message "afterTouchSensitivity:"))
  :define-event-method nil
  :define-resource nil)


(defpart double-fm-mixin (fm-mixin)
	 (&message cRatio m1Ratio m1Ind m1IndEnv m1Ind0 m1Ind1
		   m1IndAtt m1IndRel m1Waveform m1Phase bright afterTouch
		   afterTouchSensitivity
		   m2Ratio m2Ind m2IndEnv m2Ind0 m2Ind1 m2IndAtt
		   m2IndRel m2Waveform m2Phase)
  ((m2Ratio :initarg m2ratio :message "m2Ratio:")
   (m2Ind :initarg m2ind :message "m2Ind:")
   (m2IndEnv :initarg m2indenv :message "m2IndEnv:")
   (m2Ind0 :initarg m2ind0 :message "m2Ind0:")
   (m2Ind1 :initarg m2ind1 :message "m2Ind1:")
   (m2IndAtt :initarg m2indatt :message "m2IndAtt:")
   (m2IndRel :initarg m2indrel :message "m2IndRel:")
   (m2Waveform :initarg m2waveform :message "m2Waveform:")
   (m2Phase :initarg m2phase :message "m2Phase:"))
  :define-event-method nil
  :define-resource nil)

;;;
;;; midi mixins
;;;

(defpart music-kit-midi-mixin ()
	(&message keyPressure afterTouch controlChange pitchBend
		  programChange timeCodeQ songPosition songSelect
		  tuneRequest sysExclusive chanMode sysRealTime
		  basicChan controlVal monoChans velocity relVelocity
		  keyNum freq)
  ((patch :allocation :class :reader music-kit-synth-patch)
   (midiChan :initarg midiChan :initform nil :reader music-kit-midi-chan)
   (keyPressure :initarg keyPressure :message "keyPressure:")
   (afterTouch :initarg afterTouch :message "afterTouch:")
   (controlChange :initarg controlChange :message "controlChange:")
   (pitchBend :initarg pitchBend :message "pitchBend:")
   (programChange :initarg programChange :message "programChange:")
   (timeCodeQ :initarg timeCodeQ :message "timeCodeQ:")
   (songPosition :initarg songPosition :message "songPosition:")
   (songSelect :initarg songSelect :message "songSelect:")
   (tuneRequest :initarg tuneRequest :message "tuneRequest:")
   (sysExclusive :initarg sysExclusive :message "sysExclusive:"
		 :value-type :quoted-string)
   (chanMode :initarg chanMode :message "chanMode:")
   (sysRealTime :initarg sysRealTime :message "sysRealTime:")
   (basicChan :initarg basicChan :message "basicChan:")
   (controlVal :initarg controlVal :message "controlVal:")
   (monoChans :initarg monoChans :message "monoChans:")
   (velocity :initarg velocity :message "velocity:")
   (relVelocity :initarg relVelocity :message "relVelocity:")
   (keyNum :initarg keyNum :message "keyNum:")
   (freq :initarg freq :message "freq:"))
  :define-event-method nil
  :define-resource nil)