;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; dynamic calls on a clarinet phrase, similar to examp3.lisp
;;; We now have a "stickpoint" in the envelope, so we need to specify duration.

(in-package :common-music)
(in-syntax :musicKit)

(defparameter *header*
    (header "envelope ampFn = [(0,0)(.2,1)(.3,.7)|(.35,0.0)];"
	    "envelope indFn = [(0,0)(.1,1)(.2,.7)|(.3,.7)];"))


(defscorefile (pathname "examp5" header *header*)
  (in-tempo 120)	
  ;; define a local function called clarinet-lick that
  ;; sprouts a new part each time it is called.
  (flet ((clarinet-lick (pause trans) 
	   (with-part Fm1viPoly (time pause       
				 amp .1           
				 ampEnv "ampFn"  
				 ampAtt .3        
				 ampRel .2        
				 m1IndAtt .1      
				 m1IndRel .1      
				 m1Ratio 2.001    
				 cRatio 1.0       
				 m1Ind1 1         
				 m1Ind0 0         
				 m1IndEnv "indFn" 
				 sVibAmp .009     
				 sVibFreq 4       
				 rVibAmp .005     
				 rhythm (rhythm 'e)
				 bearing 0        
				 events 20)
	     (setf freq (pitch (+ (item (degrees 69 71 72)) trans))          
		   rhythm (* .94 rhythm) ; gets faster
		   m1Ind1 (+ m1Ind1 .1)	; gets brighter
		   amp (+ amp .02)))))	; gets louder

    ;; Loop sprouts clarinet-licks starting at different times.
    (loop for start from 0 to 6 by 1.0  
          as pitch-trans from 0 by 2 
          do
      (clarinet-lick start pitch-trans))))

