;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example plays a repeated phrase with the same FM instrument, now tuned 
;;; with clarinet parameters

(in-package :common-music)

(in-syntax :musicKit)

(defparameter *header*
    (header "envelope ampFn = [(0,0)(.2,1)(.3,.7)|(.35,0.0)];"
	    "envelope indFn = [(0,0)(.1,1)(.2,.7)|(.3,.7)];"))

(defscorefile (pathname "examp4" header *header*)
  (in-tempo 120)			 ; set the tempo (default is MM 60)
  (with-part Fm1viPoly (name "clarinet"  ; part "clarinet" played by Fm1viPoly
			time 0           ; Part begins at time 0
			amp .1           ; Amplitude of .1
			ampEnv "ampFn"   ; Envelope is "ampFn" specified above
			ampAtt .3        ; Amplitude envelope attack time
			ampRel .2        ; Amplitude envelope release time
			m1IndAtt .1      ; Modulator index attack time
			m1IndRel .1      ; Modulator index release time
			m1Ratio 2.001    ; Modulator portion of c:m ratio
			cRatio 1.0       ; Carrier portion of c:m ratio
			m1Ind1 1         ; Modulation index when envelope is 1
			m1Ind0 0         ; Modulation index when envelope is 0
			m1IndEnv "indFn" ; Modulation index envelope
			sVibAmp .009     ; Percentage of sinusoidal vibrato
			sVibFreq 4       ; Speed of sinusoidal vibrato
			rVibAmp .005     ; Percentage of random vibrato
			bearing 0        ; Left-right panning.
                        events 25)

    ;; lists will cycle: 7 pitches against 6 rhythms
    (setf freq (item (pitches d4 e f g a b c))
	  rhythm (item (rhythms e e e e e q)))))



