;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-


(in-package :common-music)

(in-syntax :musicKit)


(defparameter *header*
    (header "envelope ampFn = [(0,0)(.02,1)(2.5,.8)(4.0,0.0)];"
	    "envelope indFn = [(0,0)(.01,1)(1.5,.5)(3.9,0.0)];"))
     
(defscorefile (pathname "examp3" header *header*)                         

  ;; define a local function called gong-link that sprouts
  ;; a new part each time it is called.

  (flet ((gong-lick (pause base-freq)
	   (let ((m1RatioBase 3.5) 
		 (m1Ind1Base 3))
	     (with-part Fm1viPoly (time pause 
				   freq base-freq
				   rhythm (rhythm 'q)
				   amp .1           
				   ampEnv "ampFn"   
				   cRatio 1.0       
				   m1Ind0 0         
				   m1IndEnv "indFn" 
				   bearing 0        
				   events 12)	  
	       (setf m1Ratio (+ m1RatioBase (* (random 5) .01)))  
	       (setf m1Ind1 (+ m1Ind1Base (* (random 300) .01)))))))
  
    ;; Loop makes repeated calls on function gong-lick.

    (loop for start from 0 to 2 by 0.5 
          as freq1 from 50.0 by 20.0 
          do
      (gong-lick start freq1))))



