;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

(in-package :common-music)

(in-syntax :musicKit)


(defparameter *header* 
    (header "envelope ampFn = [(0,0)(.02,1)(2.5,.8)(4.0,0.0)];"
	    "envelope indFn = [(0,0)(.01,1)(1.5,.5)(3.9,0.0)];"))

(defscorefile (pathname "examp2" header *header*)                         
  ;; set nominal values to be perturbed randomly
  (let ((m1RatioBase 3.5)   
	(m1Ind1Base 3))
    (with-part Fm1viPoly (name "gong" 
			  freq (pitch 'd2)
			  rhythm (rhythm 'q)
			  time 0           
			  amp .4            
			  ampEnv "ampFn"    
			  cRatio 1.0        
			  m1Ind0 0          
			  m1IndEnv "indFn"  
			  bearing 0         
			  events 12)	   
      (setf m1Ratio (+ m1RatioBase (* (random 5) .01)))
      (setf m1Ind1 (+ m1Ind1Base (* (random 300) .01))))))



    


