;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example plays a repeated phrase with an FM instrument.
;;; Some preliminaries, first.

(in-package :common-music)
(in-syntax :musicKit)

(defparameter *header*
    (header "envelope ampFn = [(0,0)(.02,1)(2.5,.8)(4.0,0.0)];"
	    "envelope indFn   = [(0,0)(.01,1)(1.5,.5)(3.9,0.0)];"))

;;;
;;; Create scorefile examp1.score with a header defined in *header*.
;;;

(defscorefile (pathname "examp1" header *header*)
  (with-part Fm1viPoly (name "gong"        ; "gong" is played by Fm1viPoly
			time 0		   ; Part begins at time 0
			freq (pitch 'd2)   ; Part always plays d2
			rhythm (rhythm 'h) ; Part plays only half notes
			amp .1		   ; Amplitude of .1
			ampEnv "ampFn"     ; Envelope is "ampFn" above
			m1Ratio 3.5        ; Modulator portion of c:m ratio
			cRatio 1.0	   ; Carrier portion of c:m ratio
			m1Ind1 5	   ; Modulation index if envelope is 1
			m1Ind0 0	   ; Modulation index if envelope is 0
			m1IndEnv "indFn"   ; Modulation index envelope
			bearing 0	   ; Left-right panning.
			events 12)	   ; play twelve notes
        
    ;; This part does not change any parameter values, so it
    ;; does not have any runtime statements. The duration of
    ;; each note is determined by the envelope ampFn.

    ))



