;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example illustrates vibrato. First 3 notes are played, each with 
;;; more sinusoidal vibrato. Then 3 notes are played, each with more
;;; random vibrato. Then 3 notes are played with both types of vibrato
;;; and the speed is progressively increased.

(in-package :common-music)

(in-syntax :musicKit)

(defparameter *header*
    (header "envelope ampFn   = [(0,0)(.2,1)|(.35,0.0)];"
	    "waveTable aWave = [{1,.4}{2,.2}{3,.3}{4,.4}{5,.3}{6,.2}{7,.1}
                                {8,.2}{9,.25}{10,.2}{11,.1}];"))
;;;
;;; Write the score to the file "Wave1i-1.score". The scorefile header will
;;; be the value of the *header* variable. Play the score after writing it.
;;;

(defscorefile (pathname "Wave1vi-1" header *header* after 'play)

  ;; Use the Wave1viPoly part and name it "vibDemo". Start the part 
  ;; at time 0 and play 15 notes. initialize the amplitude to .1,
  ;; the amplitude envelope to "ampFn", the waveform to "aWave", 
  ;; the percentage of sinusoidal vibrato to .009, the speed of
  ;; sinusoidal vibrato to 4 and the percentage of random vibrato 
  ;; to .005. Print the amp, AmpEnv, and waveform parameter values
  ;; one time only in a noteUpdate at the beginning of the scorefile.

  (with-part Wave1viPoly (name "vibDemo" events 15 time 0
			  amp .1  ampEnv "ampFn" waveform "aWave"
			  rhythm 1.25 duration 1.0 sVibAmp .009
			  sVibFreq 4 rVibAmp .005
			  print-once '(amp ampEnv waveform))
    (setf freq1 (item (pitches d4 e fs r)))
    ;; Evaluate only when not resting
    (unless-resting                        
     (setf sVibAmp (item (items (items 0 .0075 .015)    ; increasing sVib
				(items 0 for 3)         ; then no sVib
				(items .01 for 3))      ; then constant sVib
			  :kill t)
	   rVibAmp (item  (items (items 0 for 3)        ; no rVib
				 (items 0 .0075 .015)   ; then increasing rVib
				 (items .0075 for 3)))  ; then constant rVib
	   sVibFreq (item (items (items 4.5 for 6)      ; constant sVibFreq
				 (items 3.4 4.5 5.25))) ; then increasing 
	   ))))


