;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example demonstrates the Wave1vi SynthPatch in Poly mode. It 
;;; illustrates the creation of wave tables and envelopse.

(in-package :common-music)

(in-syntax :musicKit)

;;; Music Kit envelopes and such are specified here. This text goes directly
;;; to the header of the scorefile.  We include one envelope for the amplitude.
;;; This envelope has three break-points in the attack segment and one in the 
;;; release segment.  There is no limit to how many breakpoints you can 
;;; have in a Music Kit envelope. We progressively increase the attack time 
;;; by changing the ampAtt parameter.
;;; We also include two wave tables. One is only odd harmonics and thus 
;;; resembles a clarinet. The other has two formants and suggests, 
;;; possibly, an oboe.

(defparameter *header* 
    (header "waveTable clarinetWave = [{1,1}{3,.5}{5,.25}{7,.125}{9,.1}
                                      {11,.05}{13,.025}];"
	    "waveTable oboeWave = [{1,.1}{2,.2}{3,.3}{4,.4}{5,.3}{6,.2}{7,.1}
                                  {8,.2}{9,.25}{10,.2}{11,.1}];"
	    "envelope ampFn  = [(0,0)(.2,1)|(.35,0.0)];"))

;;;
;;; Write the score to the file "Wave1i-1.score". The scorefile header will
;;; be the value of the *header* variable.
;;;

(defscorefile (pathname "Wave1i-1" header *header*)

  ;; Use the Wave1iPoly part. Name it "waveDemo" and play 15 note at a constant
  ;; rhythm of .25 seconds. Initialize the amplitude to .1, the amplitude 
  ;; envelope to "ampFn", the amplitude release to .5 and the amplitude attack
  ;; to .01. Since the values of these last 3 slots don't change, we print
  ;; them once only, using a noteUpdate at the start of the scorefile.

  (with-part Wave1iPoly (name "waveDemo" rhythm .25 events 15 amp .1 
			 ampEnv "ampFn" ampRel .5 ampAtt .01
 			 print-once '(ampEnv amp ampRel))
    (setf freq (item (pitches d4 e fs)))
    ;; Alternate waveTables
    (setf waveform (item (items "clarinetWave" "oboeWave"))) 
    ;; Pan back and forth
    (setf bearing (item (items -45 -27 0 27 45 in palindrome))) 
    ;;  AmpAtt gets ampAtt multiplied by 1.5
    (setf ampAtt (* ampAtt 1.5))))



