;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; In this example a few more elements are added:
;;; * A more complex pitch pattern is used. 
;;; * Durations are randomly set. This means that sometimes overlaps occur and 
;;;     sometimes they dont.
;;; * Brightness, an expression parameter, is set to vary in a pattern
;;;     described by a Common Music interpolation function.
;;; * The entire passage is played at a tempo of q = 128. (Note, however,
;;;     that the brightness function is looked up AFTER the tempo is applied.)

(in-package :common-music)		       ; This must begin every file.

(in-syntax :musicKit)

(defscorefile (pathname "Pluck-2")
  (in-tempo 128)
  (let ((brightness (interpolation 0 .1 3 .8 6 .2 10 .9 12 .1 15 1.0)))
    ;; Part begins at time 0, generates 50 notes, then stops.
    (with-part PluckPoly (name "guitar" time 0 events 50)
      (setf rhythm (item (rhythms e s e)))    ; Rhythm is 8th, 16th, 8th    
      (setf freq (item (items (notes c2 d e)  ; Randomly choose between 4 lists
			      (notes c3 e g)
			      (notes e4 d fs)
			      (notes e5 b4 c5)
			      in heap))) 
      (setf bright (function-value time brightness))
      (setf duration (+ .05 (random 1.5))))))

