;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example generates a scorefile to be read by the program mixsounds
;;; to create a mix of several sound files.
;;;
;;; In this simple example, the sound files on the directory 
;;; /NextLibrary/Music/Sounds are mixed. Alternatively, you can create and
;;; mix your own sound files.
;;; 
;;; To use mixsounds, follow these steps:
;;; 1. Create a LISP file that uses a MixsoundsPoly or MixsoundsMono part.
;;; 2. Run it through common music to produce the scorefile.
;;; 3. Run the scorefile through Mixsounds. (See Mixsounds documentation.)
;;; 4. Play the resulting soundfile with sndplay or SoundPlayer.


(in-package :common-music)      

(in-syntax :musicKit)

(setf *header* (header "info samplingRate:22050;"))

(defscorefile (header *header*
		      after '(mixsounds "~/test.score" "~/test.snd"))          
  (with-part MixSoundsPoly ()

    ;; Duration is how much of the file to use.  A duration of 0 means use the
    ;; whole file. TimeOffset tells where in the file to begin reading.  For
    ;; example, a time offset of 1 and a duration of 2 means begin 1 second 
    ;; into the file and continue until 3 seconds into the file. A timeOffest 
    ;; of 0 means begin at the start of the file.

    (setf duration 0)                
    (setf timeOffset 0)

    ;; Amp is the amplitude scaling to be applied to the file.  

    (setf amp (item (items .1 .2 .3)))     ; Each file is louder than previous

;; Soundfile is the file to mix.
;; We use quotify below because we need the file name to print with quotes.

    (setf soundFile (quotify (item (items "/NextLibrary/Sounds/Frog.snd"
					  "/NextLibrary/Sounds/Basso.snd"))))

    ;; The rhythm is the rhythm of when the sound files begin
    (setf rhythm (item (rhythms q e q) :kill t))))


;; (excl::shell "sndplay ~/test.snd")   ; Play it
