;;; -*- Syntax: Common-Lisp; Package: COMMON-MUSIC; Base: 10; Mode: Lisp -*-

;;; This example plays a simple melody on an external MIDI synthesizer.

(in-package :common-music)
(in-syntax :musicKit)

(defun change-midi-program (time name program)
  (format *common-music-output*
	  "~&t ~F;~&~A (mute) programChange:~D;~&" time name program))

(defscorefile (pathname "Midi-DSP")
  (with-part PluckPoly (name "aPluckPart1" pitchbend  8192)
    (setf pitchBend (incf pitchBend 100))
    (setf rhythm (item (rhythms e e e e q 
				e e e e q
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.)))
    (setf freq (item (notes d4 e f f f 
			        e g f e d 
			        f e f g  
			        a
				d5 a4 c5 bf4 g e g bf a f d
				e g f g a
				d5 a4 c5 bf4 g e g bf a f d
				e g f e d)
		       :kill t)))
  (with-part MidiPoly (name "aMidiPart1"
			    midiChan 1
			    pitchBend 8192)
    (setf pitchBend (incf pitchBend 100))
    (setf rhythm (item (rhythms e e e e e e 
				e e e e e e
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h.)))
    (setf keyNum (item (degrees d4 e f f f r 
			        e g f e d r
			        f e f r g r
			        a r
				d5 a4 c5 bf4 g e g bf a f d r
				e g f r g r a r
				d5 a4 c5 bf4 g e g bf a f d r
				e g f r e r d)
		       :kill t)))
  
  (with-part PluckPoly (name "aPluckPart2" pitchBend 8192)
    (setf rhythm (item (rhythms e e e e q 
				e e e e q
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.)))
    (setf freq (item (notes d3 e f f f 
			        e g f e d 
			        f e f g  
			        a
				d4 a3 c4 bf3 g e g bf a f d
				e g f g a
				d4 a3 c4 bf3 g e g bf a f d
				e g f e d)
		       :kill t)))
  (with-part MidiPoly (name "aMidiPart2" midiChan 2 pitchBend 8192)
    (setf rhythm (item (rhythms e e e e e e 
				e e e e e e
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h.)))
    (setf keyNum (item (degrees d3 e f f f r 
			        e g f e d r
			        f e f r g r
			        a r
				d4 a3 c4 bf3 g e g bf a f d r
				e g f r g r a r
				d4 a3 c4 bf3 g e g bf a f d r
				e g f r e r d)
		       :kill t)))

  (with-part PluckPoly (name "aPluckPart3" pitchBend 8192)
    (setf pitchBend (incf pitchBend -100))
    (setf rhythm (item (rhythms e e e e q 
				e e e e q
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.
				e e e e e e 
				e e e e q 
				e e q q 
				h.)))
    (setf freq (item (notes d2 e f f f 
			        e g f e d 
			        f e f g  
			        a
				d3 a2 c3 bf2 g e g bf a f d
				e g f g a
				d3 a2 c3 bf2 g e g bf a f d
				e g f e d)
		       :kill t)))
  (with-part MidiPoly (name "aMidiPart3" midiChan 3 pitchBend 8192)
    (setf pitchBend (incf pitchBend -100))
    (setf rhythm (item (rhythms e e e e e e 
				e e e e e e
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h q
				e e e e e e 
				e e e e e e 
				e e e e e e
				h.)))
    (setf keyNum (item (degrees d2 e f f f r 
			        e g f e d r
			        f e f r g r
			        a r
				d3 a2 c3 bf2 g e g bf a f d r
				e g f r g r a r
				d3 a2 c3 bf2 g e g bf a f d r
				e g f r e r d)
		       :kill t))

    ;; We only change MIDI program in rests because many synthesizers take
    ;; a significant amount of time to make the change. By doing it in a rest,
    ;; we give the synth time to make the change.
    (when-resting
       (change-midi-program time name (random 127)))))


